package com.xforceplus.micro.tax.cherry.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.cherry.contract.model.ElectronicInvoiceDetailInfo;
import com.xforceplus.micro.tax.cherry.contract.model.InvoiceAmountInfo;
import com.xforceplus.micro.tax.cherry.contract.model.InvoiceControlInfo;
import com.xforceplus.micro.tax.cherry.contract.model.OperatorInfo;
import com.xforceplus.micro.tax.cherry.contract.model.PurchaserInfo;
import com.xforceplus.micro.tax.cherry.contract.model.SellerInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * 电子发票信息
 */
@ApiModel(description = "电子发票信息")

@JsonInclude(NON_NULL)
public class ElectronicInvoiceInfo {
  @JsonProperty("serialNo")
  private String serialNo = null;

  @JsonProperty("invoiceType")
  private String invoiceType = "ec";

  @JsonProperty("machineCode")
  private String machineCode = null;

  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("invoiceDate")
  private String invoiceDate = null;

  @JsonProperty("checkCode")
  private String checkCode = null;

  @JsonProperty("cipherText")
  private String cipherText = null;

  @JsonProperty("remark")
  private String remark = null;

  @JsonProperty("purchaser")
  private PurchaserInfo purchaser = null;

  @JsonProperty("seller")
  private SellerInfo seller = null;

  @JsonProperty("amountInfo")
  private InvoiceAmountInfo amountInfo = null;

  @JsonProperty("operator")
  private OperatorInfo operator = null;

  @JsonProperty("details")
  private List<ElectronicInvoiceDetailInfo> details = new ArrayList<>();

  @JsonProperty("control")
  private InvoiceControlInfo control = null;

  @JsonIgnore
  public ElectronicInvoiceInfo serialNo(String serialNo) {
    this.serialNo = serialNo;
    return this;
  }

   /**
   * 流水号
   * @return serialNo
  **/


  @ApiModelProperty(value = "流水号")
  public String getSerialNo() {
    return serialNo;
  }

  public void setSerialNo(String serialNo) {
    this.serialNo = serialNo;
  }

  @JsonIgnore
  public ElectronicInvoiceInfo invoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

   /**
   * 发票类型（ec:电票,默认:ec）
   * @return invoiceType
  **/


  @ApiModelProperty(value = "发票类型（ec:电票,默认:ec）")
  public String getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
  }

  @JsonIgnore
  public ElectronicInvoiceInfo machineCode(String machineCode) {
    this.machineCode = machineCode;
    return this;
  }

   /**
   * 机器码
   * @return machineCode
  **/


  @ApiModelProperty(value = "机器码")
  public String getMachineCode() {
    return machineCode;
  }

  public void setMachineCode(String machineCode) {
    this.machineCode = machineCode;
  }

  @JsonIgnore
  public ElectronicInvoiceInfo invoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
    return this;
  }

   /**
   * 发票号码
   * @return invoiceNo
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "发票号码")
  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  @JsonIgnore
  public ElectronicInvoiceInfo invoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
    return this;
  }

   /**
   * 发票代码
   * @return invoiceCode
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "发票代码")
  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  @JsonIgnore
  public ElectronicInvoiceInfo invoiceDate(String invoiceDate) {
    this.invoiceDate = invoiceDate;
    return this;
  }

   /**
   * 开票日期(yyyyMMdd)
   * @return invoiceDate
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "开票日期(yyyyMMdd)")
  public String getInvoiceDate() {
    return invoiceDate;
  }

  public void setInvoiceDate(String invoiceDate) {
    this.invoiceDate = invoiceDate;
  }

  @JsonIgnore
  public ElectronicInvoiceInfo checkCode(String checkCode) {
    this.checkCode = checkCode;
    return this;
  }

   /**
   * 校验码
   * @return checkCode
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "校验码")
  public String getCheckCode() {
    return checkCode;
  }

  public void setCheckCode(String checkCode) {
    this.checkCode = checkCode;
  }

  @JsonIgnore
  public ElectronicInvoiceInfo cipherText(String cipherText) {
    this.cipherText = cipherText;
    return this;
  }

   /**
   * 发票密文
   * @return cipherText
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "发票密文")
  public String getCipherText() {
    return cipherText;
  }

  public void setCipherText(String cipherText) {
    this.cipherText = cipherText;
  }

  @JsonIgnore
  public ElectronicInvoiceInfo remark(String remark) {
    this.remark = remark;
    return this;
  }

   /**
   * 备注
   * @return remark
  **/


  @ApiModelProperty(value = "备注")
  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  @JsonIgnore
  public ElectronicInvoiceInfo purchaser(PurchaserInfo purchaser) {
    this.purchaser = purchaser;
    return this;
  }

   /**
   * 购方信息
   * @return purchaser
  **/

  @Valid

  @ApiModelProperty(value = "购方信息")
  public PurchaserInfo getPurchaser() {
    return purchaser;
  }

  public void setPurchaser(PurchaserInfo purchaser) {
    this.purchaser = purchaser;
  }

  @JsonIgnore
  public ElectronicInvoiceInfo seller(SellerInfo seller) {
    this.seller = seller;
    return this;
  }

   /**
   * 销方信息
   * @return seller
  **/
  @NotNull

  @Valid

  @ApiModelProperty(required = true, value = "销方信息")
  public SellerInfo getSeller() {
    return seller;
  }

  public void setSeller(SellerInfo seller) {
    this.seller = seller;
  }

  @JsonIgnore
  public ElectronicInvoiceInfo amountInfo(InvoiceAmountInfo amountInfo) {
    this.amountInfo = amountInfo;
    return this;
  }

   /**
   * 合计金额信息
   * @return amountInfo
  **/
  @NotNull

  @Valid

  @ApiModelProperty(required = true, value = "合计金额信息")
  public InvoiceAmountInfo getAmountInfo() {
    return amountInfo;
  }

  public void setAmountInfo(InvoiceAmountInfo amountInfo) {
    this.amountInfo = amountInfo;
  }

  @JsonIgnore
  public ElectronicInvoiceInfo operator(OperatorInfo operator) {
    this.operator = operator;
    return this;
  }

   /**
   * 经办人
   * @return operator
  **/

  @Valid

  @ApiModelProperty(value = "经办人")
  public OperatorInfo getOperator() {
    return operator;
  }

  public void setOperator(OperatorInfo operator) {
    this.operator = operator;
  }

  @JsonIgnore
  public ElectronicInvoiceInfo details(List<ElectronicInvoiceDetailInfo> details) {
    this.details = details;
    return this;
  }

  public ElectronicInvoiceInfo addDetailsItem(ElectronicInvoiceDetailInfo detailsItem) {
    this.details.add(detailsItem);
    return this;
  }

   /**
   * 发票明细
   * @return details
  **/
  @NotNull

  @Valid

  @ApiModelProperty(required = true, value = "发票明细")
  public List<ElectronicInvoiceDetailInfo> getDetails() {
    return details;
  }

  public void setDetails(List<ElectronicInvoiceDetailInfo> details) {
    this.details = details;
  }

  @JsonIgnore
  public ElectronicInvoiceInfo control(InvoiceControlInfo control) {
    this.control = control;
    return this;
  }

   /**
   * 发票控制项
   * @return control
  **/

  @Valid

  @ApiModelProperty(value = "发票控制项")
  public InvoiceControlInfo getControl() {
    return control;
  }

  public void setControl(InvoiceControlInfo control) {
    this.control = control;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ElectronicInvoiceInfo electronicInvoiceInfo = (ElectronicInvoiceInfo) o;
    return Objects.equals(this.serialNo, electronicInvoiceInfo.serialNo) &&
        Objects.equals(this.invoiceType, electronicInvoiceInfo.invoiceType) &&
        Objects.equals(this.machineCode, electronicInvoiceInfo.machineCode) &&
        Objects.equals(this.invoiceNo, electronicInvoiceInfo.invoiceNo) &&
        Objects.equals(this.invoiceCode, electronicInvoiceInfo.invoiceCode) &&
        Objects.equals(this.invoiceDate, electronicInvoiceInfo.invoiceDate) &&
        Objects.equals(this.checkCode, electronicInvoiceInfo.checkCode) &&
        Objects.equals(this.cipherText, electronicInvoiceInfo.cipherText) &&
        Objects.equals(this.remark, electronicInvoiceInfo.remark) &&
        Objects.equals(this.purchaser, electronicInvoiceInfo.purchaser) &&
        Objects.equals(this.seller, electronicInvoiceInfo.seller) &&
        Objects.equals(this.amountInfo, electronicInvoiceInfo.amountInfo) &&
        Objects.equals(this.operator, electronicInvoiceInfo.operator) &&
        Objects.equals(this.details, electronicInvoiceInfo.details) &&
        Objects.equals(this.control, electronicInvoiceInfo.control);
  }

  @Override
  public int hashCode() {
    return Objects.hash(serialNo, invoiceType, machineCode, invoiceNo, invoiceCode, invoiceDate, checkCode, cipherText, remark, purchaser, seller, amountInfo, operator, details, control);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ElectronicInvoiceInfo {\n");
    
    sb.append("    serialNo: ").append(toIndentedString(serialNo)).append("\n");
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("    machineCode: ").append(toIndentedString(machineCode)).append("\n");
    sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
    sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
    sb.append("    invoiceDate: ").append(toIndentedString(invoiceDate)).append("\n");
    sb.append("    checkCode: ").append(toIndentedString(checkCode)).append("\n");
    sb.append("    cipherText: ").append(toIndentedString(cipherText)).append("\n");
    sb.append("    remark: ").append(toIndentedString(remark)).append("\n");
    sb.append("    purchaser: ").append(toIndentedString(purchaser)).append("\n");
    sb.append("    seller: ").append(toIndentedString(seller)).append("\n");
    sb.append("    amountInfo: ").append(toIndentedString(amountInfo)).append("\n");
    sb.append("    operator: ").append(toIndentedString(operator)).append("\n");
    sb.append("    details: ").append(toIndentedString(details)).append("\n");
    sb.append("    control: ").append(toIndentedString(control)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
