package com.xforceplus.micro.tax.cherry.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.cherry.contract.model.ResponseHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * GenerateRedNotificationPDFResponse
 */

@JsonInclude(NON_NULL)
public class GenerateRedNotificationPDFResponse {
  @JsonProperty("head")
  private ResponseHead head = null;

  @JsonProperty("pdfUrl")
  private String pdfUrl = null;

  @JsonIgnore
  public GenerateRedNotificationPDFResponse head(ResponseHead head) {
    this.head = head;
    return this;
  }

   /**
   * 生成红字发票信息表PDF头部信息
   * @return head
  **/
  @NotNull

  @Valid

  @ApiModelProperty(required = true, value = "生成红字发票信息表PDF头部信息")
  public ResponseHead getHead() {
    return head;
  }

  public void setHead(ResponseHead head) {
    this.head = head;
  }

  @JsonIgnore
  public GenerateRedNotificationPDFResponse pdfUrl(String pdfUrl) {
    this.pdfUrl = pdfUrl;
    return this;
  }

   /**
   * pdf访问地址
   * @return pdfUrl
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "pdf访问地址")
  public String getPdfUrl() {
    return pdfUrl;
  }

  public void setPdfUrl(String pdfUrl) {
    this.pdfUrl = pdfUrl;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GenerateRedNotificationPDFResponse generateRedNotificationPDFResponse = (GenerateRedNotificationPDFResponse) o;
    return Objects.equals(this.head, generateRedNotificationPDFResponse.head) &&
        Objects.equals(this.pdfUrl, generateRedNotificationPDFResponse.pdfUrl);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, pdfUrl);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GenerateRedNotificationPDFResponse {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    pdfUrl: ").append(toIndentedString(pdfUrl)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
