package com.xforceplus.micro.tax.cherry.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * 待发票明细信息
 */
@ApiModel(description = "待发票明细信息")

@JsonInclude(NON_NULL)
public class InvoicePrintDetailInfo {
  @JsonProperty("cargoName")
  private String cargoName = null;

  @JsonProperty("itemSpec")
  private String itemSpec = null;

  @JsonProperty("quantityUnit")
  private String quantityUnit = null;

  @JsonProperty("quantity")
  private String quantity = null;

  @JsonProperty("unitPrice")
  private String unitPrice = null;

  @JsonProperty("amountWithoutTax")
  private String amountWithoutTax = null;

  @JsonProperty("taxRate")
  private String taxRate = null;

  @JsonProperty("taxAmount")
  private String taxAmount = null;

  @JsonProperty("zeroTax")
  private String zeroTax = null;

  @JsonIgnore
  public InvoicePrintDetailInfo cargoName(String cargoName) {
    this.cargoName = cargoName;
    return this;
  }

   /**
   * 货物或应税劳务名称
   * @return cargoName
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "货物或应税劳务名称")
  public String getCargoName() {
    return cargoName;
  }

  public void setCargoName(String cargoName) {
    this.cargoName = cargoName;
  }

  @JsonIgnore
  public InvoicePrintDetailInfo itemSpec(String itemSpec) {
    this.itemSpec = itemSpec;
    return this;
  }

   /**
   * 规格型号
   * @return itemSpec
  **/


  @ApiModelProperty(value = "规格型号")
  public String getItemSpec() {
    return itemSpec;
  }

  public void setItemSpec(String itemSpec) {
    this.itemSpec = itemSpec;
  }

  @JsonIgnore
  public InvoicePrintDetailInfo quantityUnit(String quantityUnit) {
    this.quantityUnit = quantityUnit;
    return this;
  }

   /**
   * 单位
   * @return quantityUnit
  **/


  @ApiModelProperty(value = "单位")
  public String getQuantityUnit() {
    return quantityUnit;
  }

  public void setQuantityUnit(String quantityUnit) {
    this.quantityUnit = quantityUnit;
  }

  @JsonIgnore
  public InvoicePrintDetailInfo quantity(String quantity) {
    this.quantity = quantity;
    return this;
  }

   /**
   * 数量(支持小数点后8位)
   * @return quantity
  **/


  @ApiModelProperty(value = "数量(支持小数点后8位)")
  public String getQuantity() {
    return quantity;
  }

  public void setQuantity(String quantity) {
    this.quantity = quantity;
  }

  @JsonIgnore
  public InvoicePrintDetailInfo unitPrice(String unitPrice) {
    this.unitPrice = unitPrice;
    return this;
  }

   /**
   * 单价(支持小数点后8位)
   * @return unitPrice
  **/


  @ApiModelProperty(value = "单价(支持小数点后8位)")
  public String getUnitPrice() {
    return unitPrice;
  }

  public void setUnitPrice(String unitPrice) {
    this.unitPrice = unitPrice;
  }

  @JsonIgnore
  public InvoicePrintDetailInfo amountWithoutTax(String amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
    return this;
  }

   /**
   * 不含税金额(支持小数点后2位)
   * @return amountWithoutTax
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "不含税金额(支持小数点后2位)")
  public String getAmountWithoutTax() {
    return amountWithoutTax;
  }

  public void setAmountWithoutTax(String amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
  }

  @JsonIgnore
  public InvoicePrintDetailInfo taxRate(String taxRate) {
    this.taxRate = taxRate;
    return this;
  }

   /**
   * 税率(示例，16%传0.16)
   * @return taxRate
  **/


  @ApiModelProperty(value = "税率(示例，16%传0.16)")
  public String getTaxRate() {
    return taxRate;
  }

  public void setTaxRate(String taxRate) {
    this.taxRate = taxRate;
  }

  @JsonIgnore
  public InvoicePrintDetailInfo taxAmount(String taxAmount) {
    this.taxAmount = taxAmount;
    return this;
  }

   /**
   * 税额(支持小数点后2位)
   * @return taxAmount
  **/


  @ApiModelProperty(value = "税额(支持小数点后2位)")
  public String getTaxAmount() {
    return taxAmount;
  }

  public void setTaxAmount(String taxAmount) {
    this.taxAmount = taxAmount;
  }

  @JsonIgnore
  public InvoicePrintDetailInfo zeroTax(String zeroTax) {
    this.zeroTax = zeroTax;
    return this;
  }

   /**
   * 税率标志 (空-非0税率；0-出口退税 1-免税 2-不征税 3-普通0税率)
   * @return zeroTax
  **/


  @ApiModelProperty(value = "税率标志 (空-非0税率；0-出口退税 1-免税 2-不征税 3-普通0税率)")
  public String getZeroTax() {
    return zeroTax;
  }

  public void setZeroTax(String zeroTax) {
    this.zeroTax = zeroTax;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoicePrintDetailInfo invoicePrintDetailInfo = (InvoicePrintDetailInfo) o;
    return Objects.equals(this.cargoName, invoicePrintDetailInfo.cargoName) &&
        Objects.equals(this.itemSpec, invoicePrintDetailInfo.itemSpec) &&
        Objects.equals(this.quantityUnit, invoicePrintDetailInfo.quantityUnit) &&
        Objects.equals(this.quantity, invoicePrintDetailInfo.quantity) &&
        Objects.equals(this.unitPrice, invoicePrintDetailInfo.unitPrice) &&
        Objects.equals(this.amountWithoutTax, invoicePrintDetailInfo.amountWithoutTax) &&
        Objects.equals(this.taxRate, invoicePrintDetailInfo.taxRate) &&
        Objects.equals(this.taxAmount, invoicePrintDetailInfo.taxAmount) &&
        Objects.equals(this.zeroTax, invoicePrintDetailInfo.zeroTax);
  }

  @Override
  public int hashCode() {
    return Objects.hash(cargoName, itemSpec, quantityUnit, quantity, unitPrice, amountWithoutTax, taxRate, taxAmount, zeroTax);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoicePrintDetailInfo {\n");
    
    sb.append("    cargoName: ").append(toIndentedString(cargoName)).append("\n");
    sb.append("    itemSpec: ").append(toIndentedString(itemSpec)).append("\n");
    sb.append("    quantityUnit: ").append(toIndentedString(quantityUnit)).append("\n");
    sb.append("    quantity: ").append(toIndentedString(quantity)).append("\n");
    sb.append("    unitPrice: ").append(toIndentedString(unitPrice)).append("\n");
    sb.append("    amountWithoutTax: ").append(toIndentedString(amountWithoutTax)).append("\n");
    sb.append("    taxRate: ").append(toIndentedString(taxRate)).append("\n");
    sb.append("    taxAmount: ").append(toIndentedString(taxAmount)).append("\n");
    sb.append("    zeroTax: ").append(toIndentedString(zeroTax)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
