package com.xforceplus.micro.tax.cherry.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * 多云地址信息
 */
@ApiModel(description = "多云地址信息")

@JsonInclude(NON_NULL)
public class MultiCloudAddr {
  @JsonProperty("dnsName")
  private String dnsName = null;

  @JsonProperty("voucherUrl")
  private String voucherUrl = null;

  @JsonIgnore
  public MultiCloudAddr dnsName(String dnsName) {
    this.dnsName = dnsName;
    return this;
  }

   /**
   * 所属云（ali：阿里，tencent：腾讯，aws：亚马逊）
   * @return dnsName
  **/


  @ApiModelProperty(value = "所属云（ali：阿里，tencent：腾讯，aws：亚马逊）")
  public String getDnsName() {
    return dnsName;
  }

  public void setDnsName(String dnsName) {
    this.dnsName = dnsName;
  }

  @JsonIgnore
  public MultiCloudAddr voucherUrl(String voucherUrl) {
    this.voucherUrl = voucherUrl;
    return this;
  }

   /**
   * 凭证地址
   * @return voucherUrl
  **/


  @ApiModelProperty(value = "凭证地址")
  public String getVoucherUrl() {
    return voucherUrl;
  }

  public void setVoucherUrl(String voucherUrl) {
    this.voucherUrl = voucherUrl;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MultiCloudAddr multiCloudAddr = (MultiCloudAddr) o;
    return Objects.equals(this.dnsName, multiCloudAddr.dnsName) &&
        Objects.equals(this.voucherUrl, multiCloudAddr.voucherUrl);
  }

  @Override
  public int hashCode() {
    return Objects.hash(dnsName, voucherUrl);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MultiCloudAddr {\n");
    
    sb.append("    dnsName: ").append(toIndentedString(dnsName)).append("\n");
    sb.append("    voucherUrl: ").append(toIndentedString(voucherUrl)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
