package com.xforceplus.micro.tax.cherry.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * 红字信息表字段信息
 */
@ApiModel(description = "红字信息表字段信息")

@JsonInclude(NON_NULL)
public class RedNotificationInfo {
  @JsonProperty("requestSerialNo")
  private String requestSerialNo = null;

  @JsonProperty("companyTaxNo")
  private String companyTaxNo = null;

  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("machineCode")
  private String machineCode = null;

  @JsonProperty("applicationReason")
  private String applicationReason = null;

  @JsonProperty("applicantName")
  private String applicantName = null;

  @JsonProperty("applicationOrganName")
  private String applicationOrganName = null;

  @JsonProperty("contactInformation")
  private String contactInformation = null;

  @JsonProperty("purchaserName")
  private String purchaserName = null;

  @JsonProperty("purchaseTaxNo")
  private String purchaseTaxNo = null;

  @JsonProperty("sellerName")
  private String sellerName = null;

  @JsonProperty("sellerTaxNo")
  private String sellerTaxNo = null;

  @JsonIgnore
  public RedNotificationInfo requestSerialNo(String requestSerialNo) {
    this.requestSerialNo = requestSerialNo;
    return this;
  }

   /**
   * 请求流水号,唯一标志
   * @return requestSerialNo
  **/


  @ApiModelProperty(value = "请求流水号,唯一标志")
  public String getRequestSerialNo() {
    return requestSerialNo;
  }

  public void setRequestSerialNo(String requestSerialNo) {
    this.requestSerialNo = requestSerialNo;
  }

  @JsonIgnore
  public RedNotificationInfo companyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
    return this;
  }

   /**
   * 申请公司税号
   * @return companyTaxNo
  **/


  @ApiModelProperty(value = "申请公司税号")
  public String getCompanyTaxNo() {
    return companyTaxNo;
  }

  public void setCompanyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
  }

  @JsonIgnore
  public RedNotificationInfo invoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
    return this;
  }

   /**
   * 发票代码
   * @return invoiceCode
  **/


  @ApiModelProperty(value = "发票代码")
  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  @JsonIgnore
  public RedNotificationInfo invoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
    return this;
  }

   /**
   * 发票号码
   * @return invoiceNo
  **/


  @ApiModelProperty(value = "发票号码")
  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  @JsonIgnore
  public RedNotificationInfo machineCode(String machineCode) {
    this.machineCode = machineCode;
    return this;
  }

   /**
   * 开票终端代码
   * @return machineCode
  **/


  @ApiModelProperty(value = "开票终端代码")
  public String getMachineCode() {
    return machineCode;
  }

  public void setMachineCode(String machineCode) {
    this.machineCode = machineCode;
  }

  @JsonIgnore
  public RedNotificationInfo applicationReason(String applicationReason) {
    this.applicationReason = applicationReason;
    return this;
  }

   /**
   * 1-购方未抵扣申请  2-销方申请
   * @return applicationReason
  **/


  @ApiModelProperty(value = "1-购方未抵扣申请  2-销方申请")
  public String getApplicationReason() {
    return applicationReason;
  }

  public void setApplicationReason(String applicationReason) {
    this.applicationReason = applicationReason;
  }

  @JsonIgnore
  public RedNotificationInfo applicantName(String applicantName) {
    this.applicantName = applicantName;
    return this;
  }

   /**
   * 申请人名称
   * @return applicantName
  **/


  @ApiModelProperty(value = "申请人名称")
  public String getApplicantName() {
    return applicantName;
  }

  public void setApplicantName(String applicantName) {
    this.applicantName = applicantName;
  }

  @JsonIgnore
  public RedNotificationInfo applicationOrganName(String applicationOrganName) {
    this.applicationOrganName = applicationOrganName;
    return this;
  }

   /**
   * 申请机关名称
   * @return applicationOrganName
  **/


  @ApiModelProperty(value = "申请机关名称")
  public String getApplicationOrganName() {
    return applicationOrganName;
  }

  public void setApplicationOrganName(String applicationOrganName) {
    this.applicationOrganName = applicationOrganName;
  }

  @JsonIgnore
  public RedNotificationInfo contactInformation(String contactInformation) {
    this.contactInformation = contactInformation;
    return this;
  }

   /**
   * 联系方式
   * @return contactInformation
  **/


  @ApiModelProperty(value = "联系方式")
  public String getContactInformation() {
    return contactInformation;
  }

  public void setContactInformation(String contactInformation) {
    this.contactInformation = contactInformation;
  }

  @JsonIgnore
  public RedNotificationInfo purchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
    return this;
  }

   /**
   * 购方名称
   * @return purchaserName
  **/


  @ApiModelProperty(value = "购方名称")
  public String getPurchaserName() {
    return purchaserName;
  }

  public void setPurchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
  }

  @JsonIgnore
  public RedNotificationInfo purchaseTaxNo(String purchaseTaxNo) {
    this.purchaseTaxNo = purchaseTaxNo;
    return this;
  }

   /**
   * 购方税号
   * @return purchaseTaxNo
  **/


  @ApiModelProperty(value = "购方税号")
  public String getPurchaseTaxNo() {
    return purchaseTaxNo;
  }

  public void setPurchaseTaxNo(String purchaseTaxNo) {
    this.purchaseTaxNo = purchaseTaxNo;
  }

  @JsonIgnore
  public RedNotificationInfo sellerName(String sellerName) {
    this.sellerName = sellerName;
    return this;
  }

   /**
   * 销方名称
   * @return sellerName
  **/


  @ApiModelProperty(value = "销方名称")
  public String getSellerName() {
    return sellerName;
  }

  public void setSellerName(String sellerName) {
    this.sellerName = sellerName;
  }

  @JsonIgnore
  public RedNotificationInfo sellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
    return this;
  }

   /**
   * 销方税号
   * @return sellerTaxNo
  **/


  @ApiModelProperty(value = "销方税号")
  public String getSellerTaxNo() {
    return sellerTaxNo;
  }

  public void setSellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RedNotificationInfo redNotificationInfo = (RedNotificationInfo) o;
    return Objects.equals(this.requestSerialNo, redNotificationInfo.requestSerialNo) &&
        Objects.equals(this.companyTaxNo, redNotificationInfo.companyTaxNo) &&
        Objects.equals(this.invoiceCode, redNotificationInfo.invoiceCode) &&
        Objects.equals(this.invoiceNo, redNotificationInfo.invoiceNo) &&
        Objects.equals(this.machineCode, redNotificationInfo.machineCode) &&
        Objects.equals(this.applicationReason, redNotificationInfo.applicationReason) &&
        Objects.equals(this.applicantName, redNotificationInfo.applicantName) &&
        Objects.equals(this.applicationOrganName, redNotificationInfo.applicationOrganName) &&
        Objects.equals(this.contactInformation, redNotificationInfo.contactInformation) &&
        Objects.equals(this.purchaserName, redNotificationInfo.purchaserName) &&
        Objects.equals(this.purchaseTaxNo, redNotificationInfo.purchaseTaxNo) &&
        Objects.equals(this.sellerName, redNotificationInfo.sellerName) &&
        Objects.equals(this.sellerTaxNo, redNotificationInfo.sellerTaxNo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(requestSerialNo, companyTaxNo, invoiceCode, invoiceNo, machineCode, applicationReason, applicantName, applicationOrganName, contactInformation, purchaserName, purchaseTaxNo, sellerName, sellerTaxNo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RedNotificationInfo {\n");
    
    sb.append("    requestSerialNo: ").append(toIndentedString(requestSerialNo)).append("\n");
    sb.append("    companyTaxNo: ").append(toIndentedString(companyTaxNo)).append("\n");
    sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
    sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
    sb.append("    machineCode: ").append(toIndentedString(machineCode)).append("\n");
    sb.append("    applicationReason: ").append(toIndentedString(applicationReason)).append("\n");
    sb.append("    applicantName: ").append(toIndentedString(applicantName)).append("\n");
    sb.append("    applicationOrganName: ").append(toIndentedString(applicationOrganName)).append("\n");
    sb.append("    contactInformation: ").append(toIndentedString(contactInformation)).append("\n");
    sb.append("    purchaserName: ").append(toIndentedString(purchaserName)).append("\n");
    sb.append("    purchaseTaxNo: ").append(toIndentedString(purchaseTaxNo)).append("\n");
    sb.append("    sellerName: ").append(toIndentedString(sellerName)).append("\n");
    sb.append("    sellerTaxNo: ").append(toIndentedString(sellerTaxNo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
