package com.xforceplus.micro.tax.cherry.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.cherry.contract.model.RequestHead;
import com.xforceplus.micro.tax.cherry.contract.model.SalesListPrintInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * SalesListPrintPDFRequest
 */

@JsonInclude(NON_NULL)
public class SalesListPrintPDFRequest {
  @JsonProperty("head")
  private RequestHead head = null;

  @JsonProperty("salesListPrintInfo")
  private SalesListPrintInfo salesListPrintInfo = null;

  @JsonIgnore
  public SalesListPrintPDFRequest head(RequestHead head) {
    this.head = head;
    return this;
  }

   /**
   * 标准请求头信息
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "标准请求头信息")
  public RequestHead getHead() {
    return head;
  }

  public void setHead(RequestHead head) {
    this.head = head;
  }

  @JsonIgnore
  public SalesListPrintPDFRequest salesListPrintInfo(SalesListPrintInfo salesListPrintInfo) {
    this.salesListPrintInfo = salesListPrintInfo;
    return this;
  }

   /**
   * 待打印发票PDF发票信息
   * @return salesListPrintInfo
  **/
  @NotNull

  @Valid

  @ApiModelProperty(required = true, value = "待打印发票PDF发票信息")
  public SalesListPrintInfo getSalesListPrintInfo() {
    return salesListPrintInfo;
  }

  public void setSalesListPrintInfo(SalesListPrintInfo salesListPrintInfo) {
    this.salesListPrintInfo = salesListPrintInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SalesListPrintPDFRequest salesListPrintPDFRequest = (SalesListPrintPDFRequest) o;
    return Objects.equals(this.head, salesListPrintPDFRequest.head) &&
        Objects.equals(this.salesListPrintInfo, salesListPrintPDFRequest.salesListPrintInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, salesListPrintInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SalesListPrintPDFRequest {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    salesListPrintInfo: ").append(toIndentedString(salesListPrintInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
