package com.xforceplus.micro.tax.cherry.contract.model.client;

import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.BaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author Bobo
 * @create 2020/12/8 16:42
 * @since 1.0.0
 */
public class GenerateDeclareTaxMessage {

    @Data
    public static class Request {

        /**
         * 报税文件结果错误码
         */
        private String processCode;

        /**
         * excel文件错误信息
         */
        private String excelInvoiceExportMsg;

        /**
         * pdf/xps数据错误信息
         */
        private String taxMonthStatMsg;

        /**
         * 厂商标识
         */
        private String vendorType = "HX";

        /**
         * 文件格式
         */
        private String fileFormat = "PDF";

        /**
         * 发票导出到Excel路径地址，客户端校验
         */
        private String invoiceExportExcelPath;

        /**
         * 设备编号
         */
        private String deviceNo;

        /**
         * 开票机号
         */
        private String invoicingMachineNo;

        /**
         * 月开票量
         */
        private String invoicingNum;

        /**
         * 标题
         */
        private String title;

        /**
         * 制表日期
         */
        private String makeTableDate;

        /**
         * 所属期间
         */
        private String taxPeriod;

        /**
         * 年月
         */
        private String yearMonth;

        /**
         * 子标题
         */
        private String subTitle;

        /**
         * 子标题2
         */
        private String subTitle2;

        /**
         * 纳税人登记号
         */
        private String taxCode;

        /**
         * 企业名称
         */
        private String companyName;

        /**
         * 地址电话
         */
        private String addressTel;

        /**
         * 期初库存份数
         */
        private String periodEarlyStockNum;

        /**
         * 购进发票份数
         */
        private String buyNum;

        /**
         * 退回发票份数
         */
        private String returnInvNum;

        /**
         * 正数发票份数
         */
        private String plusInvoiceNum;

        /**
         * 正数废票份数
         */
        private String plusInvWasteNum;

        /**
         * 期末库存份数
         */
        private String periodEndStockNum;

        /**
         * 负数发票份数
         */
        private String negativeInvoiceNum;

        /**
         * 负数废票份数
         */
        private String negativeInvWasteNum;

        /**
         * 分配发票份数
         */
        private String allotInvNum;

        /**
         * 收回发票份数
         */
        private String reclaimStockNum;

        /**
         * 合计发票份数
         */
        private String totalStockNum;

        /**
         * 销项情况
         */
        private List<OutputInfo> outputDetails;


    }

    @Data
    public static class OutputInfo {

        /**
         * 税率(合计列:total  非合计列：6%)
         */
        private String taxRate;

        /**
         * 销项正废金额
         */
        private String outputPlusWasteAmount;

        /**
         * 销项正数金额
         */
        private String outputPlusAmount;

        /**
         * 销项负废金额
         */
        private String outputNegativeWasteAmount;

        /**
         * 销项负数金额
         */
        private String outputNegativeAmount;

        /**
         * 实际销售金额
         */
        private String effectivOutputAmount;

        /**
         * 销项正废税额
         */
        private String outputPlusWasteTaxAmount;

        /**
         * 销项正数税额
         */
        private String outputPlusTaxAmount;

        /**
         * 销项负废税额
         */
        private String outputNegativeWasteTaxAmount;

        /**
         * 销项负数税额
         */
        private String outputNegativeTaxAmount;

        /**
         * 实际销项税额
         */
        private String effectivOutputTaxAmount;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private GenerateDeclareTaxMessage.Result result = new GenerateDeclareTaxMessage.Result();
    }

    @Data
    public static class Result {

        /**
         * 报税文件结果错误码
         */
        private String processCode;

        /**
         * excel文件错误信息
         */
        private String excelInvoiceExportMsg;

        /**
         * pdf/xps数据错误信息
         */
        private String taxMonthStatMsg;

        /**
         * 税号
         */
        private String taxCode;

        /**
         * 设备编号
         */
        private String deviceNo;


        /**
         * 文件格式
         */
        private String fileFormat;

        /**
         * 下载链接
         */
        private String downloadUrl;

        /**
         * 发票导出到Excel路径地址
         */
        private String invoiceExportExcelPath;

        /**
         * 年月
         */
        private String yearMonth;

        /**
         * 月开票量
         */
        private String invoicingNum;
    }

}
