package com.xforceplus.micro.tax.cherry.contract.model.vatv2;

import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.BaseResponseDto;
import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.device.ServerDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 虚拟UKey设备发行前查询
 *
 * @author Bobo
 * @create 2020/4/1 19:34
 * @since 1.0.0
 */
public class DeviceIssueQueryMessage {

    @Data
    public static class Request {

        /**
         * 发票类型
         */
        private String invoiceType;

        /**
         * 税号
         */
        private String taxCode;

        /**
         * 省份
         */
        private String province;

        /**
         * 服务器信息
         */
        private ServerDto serverInfo;

    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private DeviceIssueQueryMessage.Result result = new DeviceIssueQueryMessage.Result();
    }

    @Data
    public static class Result {

        /**
         * 待发行信息
         */
        private List<IssueInfoDto> issueList;
    }

    @Data
    public static class IssueInfoDto {

        /**
         * 纳税人识别号
         */
        private String taxCode;

        /**
         * 纳税人名称
         */
        private String taxName;

        /**
         * 可发行数量
         */
        private String issueNum;

        /**
         * 发票类型
         */
        private String invoiceType;

    }
}
