package com.xforceplus.micro.tax.cherry.contract.model.vatv2;

import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.BaseResponseDto;
import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.device.DeviceDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 纸质票接收确认
 *
 * @author Bobo
 * @create 2020/5/13 15:21
 * @since 1.0.0
 */
public class InvPaperPurConfirmMessage {

    @Data
    public static class Request {

        /**
         * 设备服务器信息
         */
        private DeviceDto deviceDto;

        /**
         * 纳税人识别号
         */
        private String taxCode;

        /**
         * 发票类型
         */
        private String invoiceType;

        /**
         * 申领序号
         */
        private String applySeq;

        /**
         * 发票领购明细
         */
        private List<InvoicePurchaseDetail> invoicePurchaseDetailList;
    }

    @Data
    public static class InvoicePurchaseDetail {

        /**
         * 发票代码
         */
        private String invoiceCode;

        /**
         * 起始发票号码
         */
        private String startInvoiceNo;

        /**
         * 终止发票号码
         */
        private String endInvoiceNo;

        /**
         * 发票份数
         */
        private String count;

    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

    }

}
