package com.xforceplus.micro.tax.cherry.contract.model.vatv2;

import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.BaseResponseDto;
import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.terminal.TerminalDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

public class InvalidInvoiceMessage {

    @Data
    public static class Request {

        /**
         * 通道类型 （vukey ： 虚拟UKey bw： 百旺税控服务器 bw-v1 ：百旺云V1）
         */
        private String channel = "vukey";

        /**
         * 请求流水号
         */
        private String serialNo;

        /**
         * 终端信息
         */
        private TerminalDto terminalInfo;

        /**
         * 发票类型(s-专票, c-普票)
         */
        private String invoiceType;

        /**
         * 纳税人识别号
         */
        private String taxCode;

        /**
         * 作废类型
         * <p>
         * 枚举: 0：空白发票作废,1：已开发票作废
         */
        private String invalidType;

        /**
         * 发票代码
         */
        private String invoiceCode;

        /**
         * 发票号码
         */
        private String invoiceNo;

        /**
         * 合计金额(空白发票作废为空，单位：元（两位小数）)
         */
        private String amountWithoutTax;

        /**
         * 作废人
         */
        private String invalidName;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        /**
         * 结果信息
         */
        private Result result;
    }

    @Data
    public static class Result {

        /**
         * 发票类型
         */
        private String invoiceType;

        /**
         * 发票代码
         */
        private String invoiceCode;

        /**
         * 发票号码
         */
        private String invoiceNo;

        /**
         * 作废日期
         */
        private String invalidDate;
    }
}
