package com.xforceplus.micro.tax.cherry.contract.model.vatv2;

import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.BaseResponseDto;
import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.makeinvoice.InvoiceDto;
import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.makeinvoice.InvoiceOptionsDto;
import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.makeinvoice.PreInvoiceDto;
import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.terminal.TerminalDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * VAT发票开具 消息
 *
 * @author Bobo
 * @create 2020/3/9 15:02
 * @since 1.0.0
 */
public class MakeInvoiceMessage {

    @Data
    public static class Request {

        /**
         * 流水号
         */
        private String serialNo;

        /**
         * 租户
         */
        private String tenantId;

        /**
         * 结算单号
         */
        private String settlementNo;

        /**
         * 通道类型 （vukey ： 虚拟UKey bw： 百旺税控服务器 bw-v1 ：百旺云V1）
         */
        private String channel = "vukey";

        /**
         * 开票终端信息
         */
        private TerminalDto terminalInfo;

        /**
         * 开票选项
         */
        private InvoiceOptionsDto invoiceOptions;

        /**
         * 预制发票信息
         */
        private PreInvoiceDto preInvoice;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private Result result = new Result();

        @Data
        public static class Result {

            /**
             * 流水号
             */
            private String serialNo;

            /**
             * 租户
             */
            private String tenantId;

            /**
             * 开票终端信息
             */
            private TerminalDto terminalInfo;

            /**
             * 发票信息
             */
            private InvoiceDto invoice;
        }
    }
}
