package com.xforceplus.micro.tax.cherry.contract.model.vatv2;

import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.BaseResponseDto;
import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.device.DeviceDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 监控数据查询
 *
 * @author zhouwen
 * @date 2020-05-08
 */
public class MonitorQueryMessage {

    @Data
    public static class Request {

        /**
         * 设备服务器信息
         */
        private DeviceDto deviceDto;

        /**
         * 发票类型(ce-电票,s-专票, c-普票)
         */
        private String invoiceType;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private Result result = new Result();

        @Data
        public static class Result {

            private MonitorDTO monitorDTO;

            @Data
            public static class MonitorDTO {

                /**
                 * 发票类型
                 */
                private String invoiceType;

                /**
                 * 开票启用时间（yyyy-MM-dd）
                 */
                private String invoiceStartDate;

                /**
                 * 开票截止时间（yyyy-MM-dd）
                 */
                private String invoiceEndDate;

                /**
                 * 数据报送起始日期（yyyy-MM-dd）
                 */
                private String reportStartDate;

                /**
                 * 数据报送终止日期（yyyy-MM-dd）
                 */
                private String reportEndDate;

                /**
                 * 单张发票限额
                 */
                private String simpleInvoiceLimitAmount;

                /**
                 * 正数发票累计限额
                 */
                private String posInvoiceAccLimitAmount;

                /**
                 * 负数发票累计限额
                 */
                private String negInvoiceAccLimitAmount;

                /**
                 * 发票累计张数限制
                 */
                private String invoiceAccLimitQuantity;

                /**
                 * 正数发票累计张数限制
                 */
                private String posInvoiceAccLimitQuantity;

                /**
                 * 负数发票累计张数限制
                 */
                private String negInvoiceAccLimitQuantity;

                /**
                 * 上传截止日期（0 ~ 31）
                 */
                private String uploadEndDate;

                /**
                 * 离线开票时长（单位: 小时）
                 */
                private String offlineMakeDuration;

                /**
                 * 离线开票张数
                 */
                private String offlineMakeNum;

                /**
                 * 离线正数累计金额
                 */
                private String posOfflineAccAmount;

                /**
                 * 离线负数累计金额
                 */
                private String negOfflineAccAmount;

                /**
                 * 最新报税日期（yyyy-MM-dd）
                 */
                private String reportLatestDate;

                /**
                 * 最新报税时间（yyyy-MM-dd HH:mm:ss）
                 */
                private String reportLatestTime;

                /**
                 * 最新回送时间（yyyy-MM-dd HH:mm:ss）
                 */
                private String loopbackLatestTime;
            }
        }
    }
}
