package com.xforceplus.micro.tax.cherry.contract.model.vatv2;

import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.BaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

public class OfdToImageMessage {

    @Data
    public static class Request {

        /**
         * ofd文件Base64
         */
        private String ofdEncode;

        /**
         * 图片格式（支持：png,jpg,tiff；默认png）
         */
        private String imageFormat;

        /**
         * 缩放比例(范围在 1-10之间,允许小数；默认5倍)
         */
        private Float ratio;

        /**
         * 页面类型
         */
        private String pageType = "InvoicePage";
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {
        private Result result = new Result();

        @Data
        public static class Result {

            /**
             * 内网图片O地址
             */
            private String internalImageUrl;

            /**
             * 图片地址
             */
            private String imageUrl;
        }
    }
}
