package com.xforceplus.micro.tax.cherry.contract.model.vatv2;

import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.BaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * OFD上传
 *
 * @author zhouwen
 * @date 2020-04-22
 */
public class OfdUploadMessage {

    @Data
    public static class Request {

        /**
         * ofd文件Base64
         */
        private String ofdEncode;

        /**
         * 是否受信任
         */
        private boolean isTrust;

        /**
         * 发票代码
         */
        private String invoiceCode;

        /**
         * 发票号码
         */
        private String invoiceNo;

        /**
         * 四位随机码
         */
        private String randomKey;

        /**
         * 是否强制覆盖
         */
        private boolean isCoverage;

        /**
         * 客户端信息
         */
        private ClientInfo clientInfo;

        /**
         * 税局ofd地址(销项聚合层)
         */
        private String taxOfdUrl;

        @Data
        public static class ClientInfo {

            /**
             * 销方名称
             */
            private String sellerName;

            /**
             * 销方税号
             */
            private String sellerTaxCode;

            /**
             * 盘号
             */
            private String diskNo;

            /**
             * 机器编号
             */
            private String machineCode;

            /**
             * 终端UN
             */
            private String terminalUn;

            /**
             * 设备UN
             */
            private String deviceUn;

            /**
             * MI
             */
            private String mi;
        }
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private Result result = new Result();

        @Data
        public static class Result {

            /**
             * 发票代码
             */
            private String invoiceCode;

            /**
             * 发票号码
             */
            private String invoiceNo;

            /**
             * ofd下载地址
             */
            private String ofdUrl;
        }
    }
}
