package com.xforceplus.micro.tax.cherry.contract.model.vatv2;

import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.BaseResponseDto;
import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.device.DeviceDto;
import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.invoice.red.BaseRedInfoResultDto;
import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.invoice.red.RedApplyDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 红字申请
 *
 * @author zhouwen
 * @date 2020-05-19
 */
public class RedApplyMessage {

    @Data
    public static class Request {

        /**
         * 流水号
         */
        private String serialNo;

        /**
         * 设备服务器信息
         */
        private DeviceDto deviceInfo;

        /**
         * 红字申请信息
         */
        private List<RedApplyDto> redInfoList;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private Result result = new Result();

        @Data
        public static class Result {

            /**
             * 流水号
             */
            private String serialNo;

            private List<RedApplyResult> redApplyResultList;

        }

        @Data
        @EqualsAndHashCode(callSuper = true)
        public static class RedApplyResult extends BaseRedInfoResultDto {

            private String pid;

            /**
             * 处理标志
             * 0:失败 1：成功
             */
            private String processFlag;

            /**
             * 处理描述
             */
            private String processRemark;

        }
    }
}
