package com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.invoice;

import lombok.Data;
import org.apache.commons.lang3.StringUtils;

/**
 * 销方
 *
 * @author Bobo
 * @create 2020/3/7 16:13
 * @since 1.0.0
 */
@Data
public class SellerDto {

    /**
     * 销方名称-必须
     */
    private String sellerName;

    /**
     * 销方税号-必须
     */
    private String sellerTaxCode;

    /**
     * 销方地址
     */
    private String sellerAddress;

    /**
     * 销方电话
     */
    private String sellerTel;

    /**
     * 销方开户行名称
     */
    private String sellerBankName;

    /**
     * 销方银行账号
     */
    private String sellerBankAccount;

    public String getSellerAddressAndTel() {
        return concat(sellerAddress, sellerTel);
    }

    public String getSellerBankAndAccount() {
        return concat(sellerBankName, sellerBankAccount);
    }

    private static String concat(String source1, String source2) {
        return String.format("%s %s", StringUtils.defaultString(source1).trim(),
                StringUtils.defaultString(source2).trim()).trim();
    }
}
