package com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.invoice.red;

import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.invoice.detail.RedDetailDto;
import lombok.Data;

import java.util.List;

/**
 * 红字信息基础信息
 *
 * @author Bobo
 * @create 2020/5/20 17:30
 * @since 1.0.0
 */
@Data
public class BaseRedInfoDto {

    /**
     * 原发票类型
     */
    private String originalInvoiceType;

    /**
     * 原发票代码
     */
    private String originalInvoiceCode;

    /**
     * 原发票号码
     */
    private String originalInvoiceNo;

    /**
     * 原开票日期
     */
    private String originalInvoiceDate;

    /**
     * 申请类型 （0-正常 1-逾期，默认：0）
     */
    private String applyType = "0";

    /**
     * 多税率标识
     */
    private String multiRateFlag;

    /**
     * 购方名称
     */
    private String purchaserName;

    /**
     * 购方税号
     */
    private String purchaserTaxCode;

    /**
     * 销方名称
     */
    private String sellerName;

    /**
     * 销方税号
     */
    private String sellerTaxCode;

    /**
     * 申请理由
     */
    private String applyReason;

    /**
     * 编码表版本号
     */
    private String taxCodeVersion;

    /**
     * 含税税率标识（0-正常发票 1-减按计征 2-差额征收）
     */
    private String dupTaxFlag;

    /**
     * 金额信息
     */
    private RedAmountDto amount;

    /**
     * 明细列表
     */
    private List<RedDetailDto> redDetailList;
}
