package com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.makeinvoice;

import com.xforceplus.micro.tax.cherry.contract.model.common.MultiCloudAddr;
import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.invoice.BaseInvoiceDto;
import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.invoice.detail.InvoiceDetailDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.List;

/**
 * 发票信息
 *
 * @author Bobo
 * @create 2020/3/9 16:06
 * @since 1.0.0
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class InvoiceDto extends BaseInvoiceDto {

    /**
     * 发票代码
     */
    private String invoiceCode;

    /**
     * 发票号码
     */
    private String invoiceNo;

    /**
     * 校验码
     */
    private String checkCode;

    /**
     * 密文
     */
    private String cipherText;

    /**
     * 二维码
     */
    private String twoCodeText;

    /**
     * 机器编号
     */
    private String machineCode;

    /**
     * 开票日期时间(yyyyMMddHHmmss)
     */
    private String invoiceDateTime;

    /**
     * 作废人
     */
    private String invalidName;

    /**
     * 作废日期(yyyyMMddHHmmss)
     */
    private String invalidDateTime;

    /**
     * 凭证类型 分为PDF或者OFD
     */
    private String voucherType;

    /**
     * 凭证 文件下载地址
     */
    private String voucherUrl;

    /**
     * 短链接 ofd或者pdf对应的
     */
    private String shortUrl;

    /**
     * 打印码（纸票时返回）
     */
    private String printCode;

    /**
     * 发票明细
     */
    private List<InvoiceDetailDto> details;

    /**
     * 多云地址
     */
    private List<MultiCloudAddr> multiCloudAddrList;
}
