package com.xforceplus.micro.tax.cherry.contract.model.vatv2.redapply;

import lombok.Data;

import java.util.List;

/**
 * 红字信息基础信息
 *
 * @author Bobo
 * @create 2021/5/14 15:50
 * @since 1.0.0
 */
@Data
public class BaseRedNotificationsApplyDto {

    /**
     * 红字信息表唯一标识（下载返回值为null）
     */
    private String pid;

    /**
     * 购方名称
     */
    private String purchaserName;

    /**
     * 购方税号
     */
    private String purchaserTaxCode;

    /**
     * 销方名称
     */
    private String sellerName;

    /**
     * 销方税号
     */
    private String sellerTaxCode;

    /**
     * 原发票类型 - 对应蓝字发票的发票类型（se:电专，s:纸专；默认 s）
     */
    private String originalInvoiceType;

    /**
     * 原发票代码 - 对应蓝字发票代码(销方申请、购方未抵扣和虚拟Ukey申请时必填
     */
    private String originalInvoiceCode;

    /**
     * 原发票号码 - 对应蓝字发票号码(销方申请、购方未抵扣和虚拟Ukey申请时必填
     */
    private String originalInvoiceNo;

    /**
     * 原开票日期 - 对应蓝票开票日期(销方申请、购方未抵扣和虚拟Ukey申请时必填
     */
    private String originalInvoiceDate;

    /**
     * 申请说明（购方发起:0-已抵扣1-未抵扣 销方发起:2-开票有误）
     */
    private String applicationReason;

    /**
     * 申请类型（0-正常 1-逾期，默认：0）
     */
    private String applyType;

    // 申请方式0：全部冲红 1：部分冲红
    /**
     * 税率标识（申请必填， 0-正常发票 1-减按计征 2-差额征收）
     */
    private String dupTaxFlag;

    /**
     * 票面金额信息
     */
    private Amount amount;

    private List<RedNotificationDetailDto> detailDtoList;

    /**
     * 金额信息
     */
    @Data
    public static class Amount {

        /**
         * 不含税金额
         */
        private String amountWithoutTax;

        /**
         * 含税金额
         */
        private String amountWithTax;

        /**
         * 税额
         */
        private String taxAmount;
    }

}
