package com.xforceplus.micro.tax.cherry.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.cherry.contract.model.GeneratePDFRedDetailInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * 生成PDF红字信息
 */
@ApiModel(description = "生成PDF红字信息")

@JsonInclude(NON_NULL)
public class GeneratePDFRedInfo {
  @JsonProperty("date")
  private String date = null;

  @JsonProperty("purchaserName")
  private String purchaserName = null;

  @JsonProperty("purchaseTaxNo")
  private String purchaseTaxNo = null;

  @JsonProperty("sellerName")
  private String sellerName = null;

  @JsonProperty("sellerTaxNo")
  private String sellerTaxNo = null;

  @JsonProperty("applicant")
  private Integer applicant = null;

  @JsonProperty("orignInvoiceCode")
  private String orignInvoiceCode = null;

  @JsonProperty("orignInvoiceNo")
  private String orignInvoiceNo = null;

  @JsonProperty("redNotificationNo")
  private String redNotificationNo = null;

  @JsonProperty("totalAmountWithoutTax")
  private String totalAmountWithoutTax = null;

  @JsonProperty("totalTaxAmount")
  private String totalTaxAmount = null;

  @JsonProperty("details")
  private List<GeneratePDFRedDetailInfo> details = new ArrayList<>();

  @JsonIgnore
  public GeneratePDFRedInfo date(String date) {
    this.date = date;
    return this;
  }

   /**
   * 填开日期(yyyyMMdd)
   * @return date
  **/


  @ApiModelProperty(value = "填开日期(yyyyMMdd)")
  public String getDate() {
    return date;
  }

  public void setDate(String date) {
    this.date = date;
  }

  @JsonIgnore
  public GeneratePDFRedInfo purchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
    return this;
  }

   /**
   * 购方名称
   * @return purchaserName
  **/


  @ApiModelProperty(value = "购方名称")
  public String getPurchaserName() {
    return purchaserName;
  }

  public void setPurchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
  }

  @JsonIgnore
  public GeneratePDFRedInfo purchaseTaxNo(String purchaseTaxNo) {
    this.purchaseTaxNo = purchaseTaxNo;
    return this;
  }

   /**
   * 购方税号
   * @return purchaseTaxNo
  **/


  @ApiModelProperty(value = "购方税号")
  public String getPurchaseTaxNo() {
    return purchaseTaxNo;
  }

  public void setPurchaseTaxNo(String purchaseTaxNo) {
    this.purchaseTaxNo = purchaseTaxNo;
  }

  @JsonIgnore
  public GeneratePDFRedInfo sellerName(String sellerName) {
    this.sellerName = sellerName;
    return this;
  }

   /**
   * 销方名称
   * @return sellerName
  **/


  @ApiModelProperty(value = "销方名称")
  public String getSellerName() {
    return sellerName;
  }

  public void setSellerName(String sellerName) {
    this.sellerName = sellerName;
  }

  @JsonIgnore
  public GeneratePDFRedInfo sellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
    return this;
  }

   /**
   * 销方税号
   * @return sellerTaxNo
  **/


  @ApiModelProperty(value = "销方税号")
  public String getSellerTaxNo() {
    return sellerTaxNo;
  }

  public void setSellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
  }

  @JsonIgnore
  public GeneratePDFRedInfo applicant(Integer applicant) {
    this.applicant = applicant;
    return this;
  }

   /**
   * 0-购方已抵扣申请 1-购买方未抵扣申请 2-销方申请
   * @return applicant
  **/


  @ApiModelProperty(value = "0-购方已抵扣申请 1-购买方未抵扣申请 2-销方申请")
  public Integer getApplicant() {
    return applicant;
  }

  public void setApplicant(Integer applicant) {
    this.applicant = applicant;
  }

  @JsonIgnore
  public GeneratePDFRedInfo orignInvoiceCode(String orignInvoiceCode) {
    this.orignInvoiceCode = orignInvoiceCode;
    return this;
  }

   /**
   * 对应蓝字发票代码
   * @return orignInvoiceCode
  **/


  @ApiModelProperty(value = "对应蓝字发票代码")
  public String getOrignInvoiceCode() {
    return orignInvoiceCode;
  }

  public void setOrignInvoiceCode(String orignInvoiceCode) {
    this.orignInvoiceCode = orignInvoiceCode;
  }

  @JsonIgnore
  public GeneratePDFRedInfo orignInvoiceNo(String orignInvoiceNo) {
    this.orignInvoiceNo = orignInvoiceNo;
    return this;
  }

   /**
   * 对应蓝字发票号码
   * @return orignInvoiceNo
  **/


  @ApiModelProperty(value = "对应蓝字发票号码")
  public String getOrignInvoiceNo() {
    return orignInvoiceNo;
  }

  public void setOrignInvoiceNo(String orignInvoiceNo) {
    this.orignInvoiceNo = orignInvoiceNo;
  }

  @JsonIgnore
  public GeneratePDFRedInfo redNotificationNo(String redNotificationNo) {
    this.redNotificationNo = redNotificationNo;
    return this;
  }

   /**
   * 信息表编号（最大长度不超过40个字符）
   * @return redNotificationNo
  **/


  @ApiModelProperty(value = "信息表编号（最大长度不超过40个字符）")
  public String getRedNotificationNo() {
    return redNotificationNo;
  }

  public void setRedNotificationNo(String redNotificationNo) {
    this.redNotificationNo = redNotificationNo;
  }

  @JsonIgnore
  public GeneratePDFRedInfo totalAmountWithoutTax(String totalAmountWithoutTax) {
    this.totalAmountWithoutTax = totalAmountWithoutTax;
    return this;
  }

   /**
   * 合计不含税金额(支持小数点后2位)
   * @return totalAmountWithoutTax
  **/


  @ApiModelProperty(value = "合计不含税金额(支持小数点后2位)")
  public String getTotalAmountWithoutTax() {
    return totalAmountWithoutTax;
  }

  public void setTotalAmountWithoutTax(String totalAmountWithoutTax) {
    this.totalAmountWithoutTax = totalAmountWithoutTax;
  }

  @JsonIgnore
  public GeneratePDFRedInfo totalTaxAmount(String totalTaxAmount) {
    this.totalTaxAmount = totalTaxAmount;
    return this;
  }

   /**
   * 合计税额(支持小数点后2位)
   * @return totalTaxAmount
  **/


  @ApiModelProperty(value = "合计税额(支持小数点后2位)")
  public String getTotalTaxAmount() {
    return totalTaxAmount;
  }

  public void setTotalTaxAmount(String totalTaxAmount) {
    this.totalTaxAmount = totalTaxAmount;
  }

  @JsonIgnore
  public GeneratePDFRedInfo details(List<GeneratePDFRedDetailInfo> details) {
    this.details = details;
    return this;
  }

  public GeneratePDFRedInfo addDetailsItem(GeneratePDFRedDetailInfo detailsItem) {
    this.details.add(detailsItem);
    return this;
  }

   /**
   * 明细信息
   * @return details
  **/

  @Valid

  @ApiModelProperty(value = "明细信息")
  public List<GeneratePDFRedDetailInfo> getDetails() {
    return details;
  }

  public void setDetails(List<GeneratePDFRedDetailInfo> details) {
    this.details = details;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GeneratePDFRedInfo generatePDFRedInfo = (GeneratePDFRedInfo) o;
    return Objects.equals(this.date, generatePDFRedInfo.date) &&
        Objects.equals(this.purchaserName, generatePDFRedInfo.purchaserName) &&
        Objects.equals(this.purchaseTaxNo, generatePDFRedInfo.purchaseTaxNo) &&
        Objects.equals(this.sellerName, generatePDFRedInfo.sellerName) &&
        Objects.equals(this.sellerTaxNo, generatePDFRedInfo.sellerTaxNo) &&
        Objects.equals(this.applicant, generatePDFRedInfo.applicant) &&
        Objects.equals(this.orignInvoiceCode, generatePDFRedInfo.orignInvoiceCode) &&
        Objects.equals(this.orignInvoiceNo, generatePDFRedInfo.orignInvoiceNo) &&
        Objects.equals(this.redNotificationNo, generatePDFRedInfo.redNotificationNo) &&
        Objects.equals(this.totalAmountWithoutTax, generatePDFRedInfo.totalAmountWithoutTax) &&
        Objects.equals(this.totalTaxAmount, generatePDFRedInfo.totalTaxAmount) &&
        Objects.equals(this.details, generatePDFRedInfo.details);
  }

  @Override
  public int hashCode() {
    return Objects.hash(date, purchaserName, purchaseTaxNo, sellerName, sellerTaxNo, applicant, orignInvoiceCode, orignInvoiceNo, redNotificationNo, totalAmountWithoutTax, totalTaxAmount, details);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GeneratePDFRedInfo {\n");
    
    sb.append("    date: ").append(toIndentedString(date)).append("\n");
    sb.append("    purchaserName: ").append(toIndentedString(purchaserName)).append("\n");
    sb.append("    purchaseTaxNo: ").append(toIndentedString(purchaseTaxNo)).append("\n");
    sb.append("    sellerName: ").append(toIndentedString(sellerName)).append("\n");
    sb.append("    sellerTaxNo: ").append(toIndentedString(sellerTaxNo)).append("\n");
    sb.append("    applicant: ").append(toIndentedString(applicant)).append("\n");
    sb.append("    orignInvoiceCode: ").append(toIndentedString(orignInvoiceCode)).append("\n");
    sb.append("    orignInvoiceNo: ").append(toIndentedString(orignInvoiceNo)).append("\n");
    sb.append("    redNotificationNo: ").append(toIndentedString(redNotificationNo)).append("\n");
    sb.append("    totalAmountWithoutTax: ").append(toIndentedString(totalAmountWithoutTax)).append("\n");
    sb.append("    totalTaxAmount: ").append(toIndentedString(totalTaxAmount)).append("\n");
    sb.append("    details: ").append(toIndentedString(details)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
