package com.xforceplus.micro.tax.cherry.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.cherry.contract.model.MultiCloudAddr;
import com.xforceplus.micro.tax.cherry.contract.model.ResponseHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * GeneratePDFResponse
 */

@JsonInclude(NON_NULL)
public class GeneratePDFResponse {
  @JsonProperty("head")
  private ResponseHead head = null;

  @JsonProperty("pdfUrl")
  private String pdfUrl = null;

  @JsonProperty("shortUrl")
  private String shortUrl = null;

  @JsonProperty("pdfEncode")
  private String pdfEncode = null;

  @JsonProperty("signatureEncode")
  private String signatureEncode = null;

  @JsonProperty("multiCloudAddrList")
  private List<MultiCloudAddr> multiCloudAddrList = new ArrayList<>();

  @JsonIgnore
  public GeneratePDFResponse head(ResponseHead head) {
    this.head = head;
    return this;
  }

   /**
   * 生成PDF头部信息
   * @return head
  **/
  @NotNull

  @Valid

  @ApiModelProperty(required = true, value = "生成PDF头部信息")
  public ResponseHead getHead() {
    return head;
  }

  public void setHead(ResponseHead head) {
    this.head = head;
  }

  @JsonIgnore
  public GeneratePDFResponse pdfUrl(String pdfUrl) {
    this.pdfUrl = pdfUrl;
    return this;
  }

   /**
   * pdf访问地址
   * @return pdfUrl
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "pdf访问地址")
  public String getPdfUrl() {
    return pdfUrl;
  }

  public void setPdfUrl(String pdfUrl) {
    this.pdfUrl = pdfUrl;
  }

  @JsonIgnore
  public GeneratePDFResponse shortUrl(String shortUrl) {
    this.shortUrl = shortUrl;
    return this;
  }

   /**
   * pdf短链访问地址
   * @return shortUrl
  **/


  @ApiModelProperty(value = "pdf短链访问地址")
  public String getShortUrl() {
    return shortUrl;
  }

  public void setShortUrl(String shortUrl) {
    this.shortUrl = shortUrl;
  }

  @JsonIgnore
  public GeneratePDFResponse pdfEncode(String pdfEncode) {
    this.pdfEncode = pdfEncode;
    return this;
  }

   /**
   * 未签名PDF文件(Base64)
   * @return pdfEncode
  **/


  @ApiModelProperty(value = "未签名PDF文件(Base64)")
  public String getPdfEncode() {
    return pdfEncode;
  }

  public void setPdfEncode(String pdfEncode) {
    this.pdfEncode = pdfEncode;
  }

  @JsonIgnore
  public GeneratePDFResponse signatureEncode(String signatureEncode) {
    this.signatureEncode = signatureEncode;
    return this;
  }

   /**
   * 签章文件(Base64)
   * @return signatureEncode
  **/


  @ApiModelProperty(value = "签章文件(Base64)")
  public String getSignatureEncode() {
    return signatureEncode;
  }

  public void setSignatureEncode(String signatureEncode) {
    this.signatureEncode = signatureEncode;
  }

  @JsonIgnore
  public GeneratePDFResponse multiCloudAddrList(List<MultiCloudAddr> multiCloudAddrList) {
    this.multiCloudAddrList = multiCloudAddrList;
    return this;
  }

  public GeneratePDFResponse addMultiCloudAddrListItem(MultiCloudAddr multiCloudAddrListItem) {
    this.multiCloudAddrList.add(multiCloudAddrListItem);
    return this;
  }

   /**
   * 多云地址
   * @return multiCloudAddrList
  **/

  @Valid

  @ApiModelProperty(value = "多云地址")
  public List<MultiCloudAddr> getMultiCloudAddrList() {
    return multiCloudAddrList;
  }

  public void setMultiCloudAddrList(List<MultiCloudAddr> multiCloudAddrList) {
    this.multiCloudAddrList = multiCloudAddrList;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GeneratePDFResponse generatePDFResponse = (GeneratePDFResponse) o;
    return Objects.equals(this.head, generatePDFResponse.head) &&
        Objects.equals(this.pdfUrl, generatePDFResponse.pdfUrl) &&
        Objects.equals(this.shortUrl, generatePDFResponse.shortUrl) &&
        Objects.equals(this.pdfEncode, generatePDFResponse.pdfEncode) &&
        Objects.equals(this.signatureEncode, generatePDFResponse.signatureEncode) &&
        Objects.equals(this.multiCloudAddrList, generatePDFResponse.multiCloudAddrList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, pdfUrl, shortUrl, pdfEncode, signatureEncode, multiCloudAddrList);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GeneratePDFResponse {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    pdfUrl: ").append(toIndentedString(pdfUrl)).append("\n");
    sb.append("    shortUrl: ").append(toIndentedString(shortUrl)).append("\n");
    sb.append("    pdfEncode: ").append(toIndentedString(pdfEncode)).append("\n");
    sb.append("    signatureEncode: ").append(toIndentedString(signatureEncode)).append("\n");
    sb.append("    multiCloudAddrList: ").append(toIndentedString(multiCloudAddrList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
