package com.xforceplus.micro.tax.cherry.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * 发票开具控制项
 */
@ApiModel(description = "发票开具控制项")

@JsonInclude(NON_NULL)
public class InvoiceControlInfo {
  @JsonProperty("isBlockChain")
  private Boolean isBlockChain = false;

  @JsonProperty("productOil")
  private Boolean productOil = false;

  @JsonProperty("templateVersion")
  private String templateVersion = null;

  @JsonProperty("isShortLink")
  private Boolean isShortLink = false;

  @JsonProperty("isMultiCloudAddr")
  private Boolean isMultiCloudAddr = false;

  @JsonProperty("signatureType")
  private String signatureType = null;

  @JsonIgnore
  public InvoiceControlInfo isBlockChain(Boolean isBlockChain) {
    this.isBlockChain = isBlockChain;
    return this;
  }

   /**
   * 是否是区块链发票 <默认不是区块链>
   * @return isBlockChain
  **/


  @ApiModelProperty(value = "是否是区块链发票 <默认不是区块链>")
  public Boolean IsBlockChain() {
    return isBlockChain;
  }

  public void setIsBlockChain(Boolean isBlockChain) {
    this.isBlockChain = isBlockChain;
  }

  @JsonIgnore
  public InvoiceControlInfo productOil(Boolean productOil) {
    this.productOil = productOil;
    return this;
  }

   /**
   * 成品油标识 <默认不是不是>
   * @return productOil
  **/


  @ApiModelProperty(value = "成品油标识 <默认不是不是>")
  public Boolean ProductOil() {
    return productOil;
  }

  public void setProductOil(Boolean productOil) {
    this.productOil = productOil;
  }

  @JsonIgnore
  public InvoiceControlInfo templateVersion(String templateVersion) {
    this.templateVersion = templateVersion;
    return this;
  }

   /**
   * 版式文件版本 (0-使用5行模版, 1-使用8行模版，无值等同0)
   * @return templateVersion
  **/


  @ApiModelProperty(value = "版式文件版本 (0-使用5行模版, 1-使用8行模版，无值等同0)")
  public String getTemplateVersion() {
    return templateVersion;
  }

  public void setTemplateVersion(String templateVersion) {
    this.templateVersion = templateVersion;
  }

  @JsonIgnore
  public InvoiceControlInfo isShortLink(Boolean isShortLink) {
    this.isShortLink = isShortLink;
    return this;
  }

   /**
   * 是否需要生成短链(默认为false)
   * @return isShortLink
  **/


  @ApiModelProperty(value = "是否需要生成短链(默认为false)")
  public Boolean IsShortLink() {
    return isShortLink;
  }

  public void setIsShortLink(Boolean isShortLink) {
    this.isShortLink = isShortLink;
  }

  @JsonIgnore
  public InvoiceControlInfo isMultiCloudAddr(Boolean isMultiCloudAddr) {
    this.isMultiCloudAddr = isMultiCloudAddr;
    return this;
  }

   /**
   * 是否需要多云PDF地址(默认为false)
   * @return isMultiCloudAddr
  **/


  @ApiModelProperty(value = "是否需要多云PDF地址(默认为false)")
  public Boolean IsMultiCloudAddr() {
    return isMultiCloudAddr;
  }

  public void setIsMultiCloudAddr(Boolean isMultiCloudAddr) {
    this.isMultiCloudAddr = isMultiCloudAddr;
  }

  @JsonIgnore
  public InvoiceControlInfo signatureType(String signatureType) {
    this.signatureType = signatureType;
    return this;
  }

   /**
   * 签名类型(server - 服务端（默认）client - 客户端)
   * @return signatureType
  **/


  @ApiModelProperty(value = "签名类型(server - 服务端（默认）client - 客户端)")
  public String getSignatureType() {
    return signatureType;
  }

  public void setSignatureType(String signatureType) {
    this.signatureType = signatureType;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoiceControlInfo invoiceControlInfo = (InvoiceControlInfo) o;
    return Objects.equals(this.isBlockChain, invoiceControlInfo.isBlockChain) &&
        Objects.equals(this.productOil, invoiceControlInfo.productOil) &&
        Objects.equals(this.templateVersion, invoiceControlInfo.templateVersion) &&
        Objects.equals(this.isShortLink, invoiceControlInfo.isShortLink) &&
        Objects.equals(this.isMultiCloudAddr, invoiceControlInfo.isMultiCloudAddr) &&
        Objects.equals(this.signatureType, invoiceControlInfo.signatureType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(isBlockChain, productOil, templateVersion, isShortLink, isMultiCloudAddr, signatureType);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoiceControlInfo {\n");
    
    sb.append("    isBlockChain: ").append(toIndentedString(isBlockChain)).append("\n");
    sb.append("    productOil: ").append(toIndentedString(productOil)).append("\n");
    sb.append("    templateVersion: ").append(toIndentedString(templateVersion)).append("\n");
    sb.append("    isShortLink: ").append(toIndentedString(isShortLink)).append("\n");
    sb.append("    isMultiCloudAddr: ").append(toIndentedString(isMultiCloudAddr)).append("\n");
    sb.append("    signatureType: ").append(toIndentedString(signatureType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
