package com.xforceplus.micro.tax.cherry.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.cherry.contract.model.RequestHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * ReceiveDispatcherRequest
 */

@JsonInclude(NON_NULL)
public class ReceiveDispatcherRequest {
  @JsonProperty("head")
  private RequestHead head = null;

  @JsonProperty("requestSerialNo")
  private String requestSerialNo = null;

  @JsonProperty("terminalNo")
  private String terminalNo = null;

  @JsonProperty("invoiceType")
  private String invoiceType = null;

  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("invoiceBeginNo")
  private String invoiceBeginNo = null;

  @JsonProperty("invoiceNum")
  private String invoiceNum = null;

  @JsonIgnore
  public ReceiveDispatcherRequest head(RequestHead head) {
    this.head = head;
    return this;
  }

   /**
   * 发票领购信息分发请求
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "发票领购信息分发请求")
  public RequestHead getHead() {
    return head;
  }

  public void setHead(RequestHead head) {
    this.head = head;
  }

  @JsonIgnore
  public ReceiveDispatcherRequest requestSerialNo(String requestSerialNo) {
    this.requestSerialNo = requestSerialNo;
    return this;
  }

   /**
   * 请求流水号,唯一标志
   * @return requestSerialNo
  **/


  @ApiModelProperty(value = "请求流水号,唯一标志")
  public String getRequestSerialNo() {
    return requestSerialNo;
  }

  public void setRequestSerialNo(String requestSerialNo) {
    this.requestSerialNo = requestSerialNo;
  }

  @JsonIgnore
  public ReceiveDispatcherRequest terminalNo(String terminalNo) {
    this.terminalNo = terminalNo;
    return this;
  }

   /**
   * 开票终端标识：开票终端唯一性标识
   * @return terminalNo
  **/


  @ApiModelProperty(value = "开票终端标识：开票终端唯一性标识")
  public String getTerminalNo() {
    return terminalNo;
  }

  public void setTerminalNo(String terminalNo) {
    this.terminalNo = terminalNo;
  }

  @JsonIgnore
  public ReceiveDispatcherRequest invoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

   /**
   * 申请发票类型：s:增值税专票，c:增值税普票，ce:电子发票
   * @return invoiceType
  **/


  @ApiModelProperty(value = "申请发票类型：s:增值税专票，c:增值税普票，ce:电子发票")
  public String getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
  }

  @JsonIgnore
  public ReceiveDispatcherRequest invoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
    return this;
  }

   /**
   * 发票代码
   * @return invoiceCode
  **/


  @ApiModelProperty(value = "发票代码")
  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  @JsonIgnore
  public ReceiveDispatcherRequest invoiceBeginNo(String invoiceBeginNo) {
    this.invoiceBeginNo = invoiceBeginNo;
    return this;
  }

   /**
   * 起始号码
   * @return invoiceBeginNo
  **/


  @ApiModelProperty(value = "起始号码")
  public String getInvoiceBeginNo() {
    return invoiceBeginNo;
  }

  public void setInvoiceBeginNo(String invoiceBeginNo) {
    this.invoiceBeginNo = invoiceBeginNo;
  }

  @JsonIgnore
  public ReceiveDispatcherRequest invoiceNum(String invoiceNum) {
    this.invoiceNum = invoiceNum;
    return this;
  }

   /**
   * 发票份数
   * @return invoiceNum
  **/


  @ApiModelProperty(value = "发票份数")
  public String getInvoiceNum() {
    return invoiceNum;
  }

  public void setInvoiceNum(String invoiceNum) {
    this.invoiceNum = invoiceNum;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ReceiveDispatcherRequest receiveDispatcherRequest = (ReceiveDispatcherRequest) o;
    return Objects.equals(this.head, receiveDispatcherRequest.head) &&
        Objects.equals(this.requestSerialNo, receiveDispatcherRequest.requestSerialNo) &&
        Objects.equals(this.terminalNo, receiveDispatcherRequest.terminalNo) &&
        Objects.equals(this.invoiceType, receiveDispatcherRequest.invoiceType) &&
        Objects.equals(this.invoiceCode, receiveDispatcherRequest.invoiceCode) &&
        Objects.equals(this.invoiceBeginNo, receiveDispatcherRequest.invoiceBeginNo) &&
        Objects.equals(this.invoiceNum, receiveDispatcherRequest.invoiceNum);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, requestSerialNo, terminalNo, invoiceType, invoiceCode, invoiceBeginNo, invoiceNum);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ReceiveDispatcherRequest {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    requestSerialNo: ").append(toIndentedString(requestSerialNo)).append("\n");
    sb.append("    terminalNo: ").append(toIndentedString(terminalNo)).append("\n");
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
    sb.append("    invoiceBeginNo: ").append(toIndentedString(invoiceBeginNo)).append("\n");
    sb.append("    invoiceNum: ").append(toIndentedString(invoiceNum)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
