package com.xforceplus.micro.tax.cherry.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.cherry.contract.model.RequestHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * ReceiveRequest
 */

@JsonInclude(NON_NULL)
public class ReceiveRequest {
  @JsonProperty("head")
  private RequestHead head = null;

  @JsonProperty("requestSerialNo")
  private String requestSerialNo = null;

  @JsonProperty("taxNo")
  private String taxNo = null;

  @JsonProperty("invoiceType")
  private String invoiceType = null;

  @JsonIgnore
  public ReceiveRequest head(RequestHead head) {
    this.head = head;
    return this;
  }

   /**
   * 标准请求头信息
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "标准请求头信息")
  public RequestHead getHead() {
    return head;
  }

  public void setHead(RequestHead head) {
    this.head = head;
  }

  @JsonIgnore
  public ReceiveRequest requestSerialNo(String requestSerialNo) {
    this.requestSerialNo = requestSerialNo;
    return this;
  }

   /**
   * 请求流水号,唯一标志
   * @return requestSerialNo
  **/


  @ApiModelProperty(value = "请求流水号,唯一标志")
  public String getRequestSerialNo() {
    return requestSerialNo;
  }

  public void setRequestSerialNo(String requestSerialNo) {
    this.requestSerialNo = requestSerialNo;
  }

  @JsonIgnore
  public ReceiveRequest taxNo(String taxNo) {
    this.taxNo = taxNo;
    return this;
  }

   /**
   * 纳税人识别号
   * @return taxNo
  **/


  @ApiModelProperty(value = "纳税人识别号")
  public String getTaxNo() {
    return taxNo;
  }

  public void setTaxNo(String taxNo) {
    this.taxNo = taxNo;
  }

  @JsonIgnore
  public ReceiveRequest invoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

   /**
   * 申请发票类型：s:增值税专票，c:增值税普票，ce:电子发票
   * @return invoiceType
  **/


  @ApiModelProperty(value = "申请发票类型：s:增值税专票，c:增值税普票，ce:电子发票")
  public String getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ReceiveRequest receiveRequest = (ReceiveRequest) o;
    return Objects.equals(this.head, receiveRequest.head) &&
        Objects.equals(this.requestSerialNo, receiveRequest.requestSerialNo) &&
        Objects.equals(this.taxNo, receiveRequest.taxNo) &&
        Objects.equals(this.invoiceType, receiveRequest.invoiceType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, requestSerialNo, taxNo, invoiceType);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ReceiveRequest {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    requestSerialNo: ").append(toIndentedString(requestSerialNo)).append("\n");
    sb.append("    taxNo: ").append(toIndentedString(taxNo)).append("\n");
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
