package com.xforceplus.micro.tax.cherry.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.cherry.contract.model.ReceiveInfo;
import com.xforceplus.micro.tax.cherry.contract.model.ResponseHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * ReceiveResponse
 */

@JsonInclude(NON_NULL)
public class ReceiveResponse {
  @JsonProperty("head")
  private ResponseHead head = null;

  @JsonProperty("receiveInfo")
  private ReceiveInfo receiveInfo = null;

  @JsonIgnore
  public ReceiveResponse head(ResponseHead head) {
    this.head = head;
    return this;
  }

   /**
   * 发票领购信息响应
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "发票领购信息响应")
  public ResponseHead getHead() {
    return head;
  }

  public void setHead(ResponseHead head) {
    this.head = head;
  }

  @JsonIgnore
  public ReceiveResponse receiveInfo(ReceiveInfo receiveInfo) {
    this.receiveInfo = receiveInfo;
    return this;
  }

   /**
   * 发票领购信息
   * @return receiveInfo
  **/

  @Valid

  @ApiModelProperty(value = "发票领购信息")
  public ReceiveInfo getReceiveInfo() {
    return receiveInfo;
  }

  public void setReceiveInfo(ReceiveInfo receiveInfo) {
    this.receiveInfo = receiveInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ReceiveResponse receiveResponse = (ReceiveResponse) o;
    return Objects.equals(this.head, receiveResponse.head) &&
        Objects.equals(this.receiveInfo, receiveResponse.receiveInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, receiveInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ReceiveResponse {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    receiveInfo: ").append(toIndentedString(receiveInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
