package com.xforceplus.micro.tax.cherry.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.cherry.contract.model.ResponseHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * RedNotificationApplyResultResponse
 */

@JsonInclude(NON_NULL)
public class RedNotificationApplyResultResponse {
  @JsonProperty("head")
  private ResponseHead head = null;

  @JsonProperty("requestSerialNo")
  private String requestSerialNo = null;

  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("redNotficationNo")
  private String redNotficationNo = null;

  @JsonProperty("requestBillNo")
  private String requestBillNo = null;

  @JsonIgnore
  public RedNotificationApplyResultResponse head(ResponseHead head) {
    this.head = head;
    return this;
  }

   /**
   * 红字信息表申请响应头(返回代码:负数：表示失败 0:表示处理中，1:表示处理完成 )
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "红字信息表申请响应头(返回代码:负数：表示失败 0:表示处理中，1:表示处理完成 )")
  public ResponseHead getHead() {
    return head;
  }

  public void setHead(ResponseHead head) {
    this.head = head;
  }

  @JsonIgnore
  public RedNotificationApplyResultResponse requestSerialNo(String requestSerialNo) {
    this.requestSerialNo = requestSerialNo;
    return this;
  }

   /**
   * 请求流水号,唯一标志
   * @return requestSerialNo
  **/


  @ApiModelProperty(value = "请求流水号,唯一标志")
  public String getRequestSerialNo() {
    return requestSerialNo;
  }

  public void setRequestSerialNo(String requestSerialNo) {
    this.requestSerialNo = requestSerialNo;
  }

  @JsonIgnore
  public RedNotificationApplyResultResponse invoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
    return this;
  }

   /**
   * 蓝字发票代码
   * @return invoiceCode
  **/


  @ApiModelProperty(value = "蓝字发票代码")
  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  @JsonIgnore
  public RedNotificationApplyResultResponse invoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
    return this;
  }

   /**
   * 蓝字发票号码
   * @return invoiceNo
  **/


  @ApiModelProperty(value = "蓝字发票号码")
  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  @JsonIgnore
  public RedNotificationApplyResultResponse redNotficationNo(String redNotficationNo) {
    this.redNotficationNo = redNotficationNo;
    return this;
  }

   /**
   * 信息表编号
   * @return redNotficationNo
  **/


  @ApiModelProperty(value = "信息表编号")
  public String getRedNotficationNo() {
    return redNotficationNo;
  }

  public void setRedNotficationNo(String redNotficationNo) {
    this.redNotficationNo = redNotficationNo;
  }

  @JsonIgnore
  public RedNotificationApplyResultResponse requestBillNo(String requestBillNo) {
    this.requestBillNo = requestBillNo;
    return this;
  }

   /**
   * 申请单编号
   * @return requestBillNo
  **/


  @ApiModelProperty(value = "申请单编号")
  public String getRequestBillNo() {
    return requestBillNo;
  }

  public void setRequestBillNo(String requestBillNo) {
    this.requestBillNo = requestBillNo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RedNotificationApplyResultResponse redNotificationApplyResultResponse = (RedNotificationApplyResultResponse) o;
    return Objects.equals(this.head, redNotificationApplyResultResponse.head) &&
        Objects.equals(this.requestSerialNo, redNotificationApplyResultResponse.requestSerialNo) &&
        Objects.equals(this.invoiceCode, redNotificationApplyResultResponse.invoiceCode) &&
        Objects.equals(this.invoiceNo, redNotificationApplyResultResponse.invoiceNo) &&
        Objects.equals(this.redNotficationNo, redNotificationApplyResultResponse.redNotficationNo) &&
        Objects.equals(this.requestBillNo, redNotificationApplyResultResponse.requestBillNo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, requestSerialNo, invoiceCode, invoiceNo, redNotficationNo, requestBillNo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RedNotificationApplyResultResponse {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    requestSerialNo: ").append(toIndentedString(requestSerialNo)).append("\n");
    sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
    sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
    sb.append("    redNotficationNo: ").append(toIndentedString(redNotficationNo)).append("\n");
    sb.append("    requestBillNo: ").append(toIndentedString(requestBillNo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
