package com.xforceplus.micro.tax.cherry.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * 红字信息表下载字段信息
 */
@ApiModel(description = "红字信息表下载字段信息")

@JsonInclude(NON_NULL)
public class RedNotificationDownloadInfo {
  @JsonProperty("requestSerialNo")
  private String requestSerialNo = null;

  @JsonProperty("companyTaxNo")
  private String companyTaxNo = null;

  @JsonProperty("machineCode")
  private String machineCode = null;

  @JsonProperty("overdueStatus")
  private String overdueStatus = null;

  @JsonProperty("startDate")
  private String startDate = null;

  @JsonProperty("endDate")
  private String endDate = null;

  @JsonProperty("purchaserTaxNo")
  private String purchaserTaxNo = null;

  @JsonProperty("sellerTaxNo")
  private String sellerTaxNo = null;

  @JsonProperty("redNotificationNo")
  private String redNotificationNo = null;

  @JsonProperty("downloadRange")
  private String downloadRange = null;

  @JsonProperty("pageNo")
  private String pageNo = null;

  @JsonProperty("pageSize")
  private String pageSize = null;

  @JsonIgnore
  public RedNotificationDownloadInfo requestSerialNo(String requestSerialNo) {
    this.requestSerialNo = requestSerialNo;
    return this;
  }

   /**
   * 请求流水号,唯一标志
   * @return requestSerialNo
  **/


  @ApiModelProperty(value = "请求流水号,唯一标志")
  public String getRequestSerialNo() {
    return requestSerialNo;
  }

  public void setRequestSerialNo(String requestSerialNo) {
    this.requestSerialNo = requestSerialNo;
  }

  @JsonIgnore
  public RedNotificationDownloadInfo companyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
    return this;
  }

   /**
   * 公司税号
   * @return companyTaxNo
  **/


  @ApiModelProperty(value = "公司税号")
  public String getCompanyTaxNo() {
    return companyTaxNo;
  }

  public void setCompanyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
  }

  @JsonIgnore
  public RedNotificationDownloadInfo machineCode(String machineCode) {
    this.machineCode = machineCode;
    return this;
  }

   /**
   * 开票机号
   * @return machineCode
  **/


  @ApiModelProperty(value = "开票机号")
  public String getMachineCode() {
    return machineCode;
  }

  public void setMachineCode(String machineCode) {
    this.machineCode = machineCode;
  }

  @JsonIgnore
  public RedNotificationDownloadInfo overdueStatus(String overdueStatus) {
    this.overdueStatus = overdueStatus;
    return this;
  }

   /**
   * 逾期状态 N-未逾期 Y-逾期 百旺单机时，该参数无效
   * @return overdueStatus
  **/


  @ApiModelProperty(value = "逾期状态 N-未逾期 Y-逾期 百旺单机时，该参数无效")
  public String getOverdueStatus() {
    return overdueStatus;
  }

  public void setOverdueStatus(String overdueStatus) {
    this.overdueStatus = overdueStatus;
  }

  @JsonIgnore
  public RedNotificationDownloadInfo startDate(String startDate) {
    this.startDate = startDate;
    return this;
  }

   /**
   * 填开起始日期：请求下载的红字信息表范围
   * @return startDate
  **/


  @ApiModelProperty(value = "填开起始日期：请求下载的红字信息表范围")
  public String getStartDate() {
    return startDate;
  }

  public void setStartDate(String startDate) {
    this.startDate = startDate;
  }

  @JsonIgnore
  public RedNotificationDownloadInfo endDate(String endDate) {
    this.endDate = endDate;
    return this;
  }

   /**
   * 填开终止日期：请求下载的红字信息表范围
   * @return endDate
  **/


  @ApiModelProperty(value = "填开终止日期：请求下载的红字信息表范围")
  public String getEndDate() {
    return endDate;
  }

  public void setEndDate(String endDate) {
    this.endDate = endDate;
  }

  @JsonIgnore
  public RedNotificationDownloadInfo purchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
    return this;
  }

   /**
   * 购方税号：百旺单机时，该参数无效
   * @return purchaserTaxNo
  **/


  @ApiModelProperty(value = "购方税号：百旺单机时，该参数无效")
  public String getPurchaserTaxNo() {
    return purchaserTaxNo;
  }

  public void setPurchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
  }

  @JsonIgnore
  public RedNotificationDownloadInfo sellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
    return this;
  }

   /**
   * 销方税号：百旺单机时，该参数无效
   * @return sellerTaxNo
  **/


  @ApiModelProperty(value = "销方税号：百旺单机时，该参数无效")
  public String getSellerTaxNo() {
    return sellerTaxNo;
  }

  public void setSellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
  }

  @JsonIgnore
  public RedNotificationDownloadInfo redNotificationNo(String redNotificationNo) {
    this.redNotificationNo = redNotificationNo;
    return this;
  }

   /**
   * 信息表编号
   * @return redNotificationNo
  **/


  @ApiModelProperty(value = "信息表编号")
  public String getRedNotificationNo() {
    return redNotificationNo;
  }

  public void setRedNotificationNo(String redNotificationNo) {
    this.redNotificationNo = redNotificationNo;
  }

  @JsonIgnore
  public RedNotificationDownloadInfo downloadRange(String downloadRange) {
    this.downloadRange = downloadRange;
    return this;
  }

   /**
   * 信息表下载范围：0-全部 1-销方申请 2-购方申请 百旺单机时，该参数无效
   * @return downloadRange
  **/


  @ApiModelProperty(value = "信息表下载范围：0-全部 1-销方申请 2-购方申请 百旺单机时，该参数无效")
  public String getDownloadRange() {
    return downloadRange;
  }

  public void setDownloadRange(String downloadRange) {
    this.downloadRange = downloadRange;
  }

  @JsonIgnore
  public RedNotificationDownloadInfo pageNo(String pageNo) {
    this.pageNo = pageNo;
    return this;
  }

   /**
   * 页号 从1开始  百旺单机时，该参数无效
   * @return pageNo
  **/


  @ApiModelProperty(value = "页号 从1开始  百旺单机时，该参数无效")
  public String getPageNo() {
    return pageNo;
  }

  public void setPageNo(String pageNo) {
    this.pageNo = pageNo;
  }

  @JsonIgnore
  public RedNotificationDownloadInfo pageSize(String pageSize) {
    this.pageSize = pageSize;
    return this;
  }

   /**
   * 页数 空-返回范围内所有信息表 每页一张红字信息表） 百旺单机时，该参数无效
   * @return pageSize
  **/


  @ApiModelProperty(value = "页数 空-返回范围内所有信息表 每页一张红字信息表） 百旺单机时，该参数无效")
  public String getPageSize() {
    return pageSize;
  }

  public void setPageSize(String pageSize) {
    this.pageSize = pageSize;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RedNotificationDownloadInfo redNotificationDownloadInfo = (RedNotificationDownloadInfo) o;
    return Objects.equals(this.requestSerialNo, redNotificationDownloadInfo.requestSerialNo) &&
        Objects.equals(this.companyTaxNo, redNotificationDownloadInfo.companyTaxNo) &&
        Objects.equals(this.machineCode, redNotificationDownloadInfo.machineCode) &&
        Objects.equals(this.overdueStatus, redNotificationDownloadInfo.overdueStatus) &&
        Objects.equals(this.startDate, redNotificationDownloadInfo.startDate) &&
        Objects.equals(this.endDate, redNotificationDownloadInfo.endDate) &&
        Objects.equals(this.purchaserTaxNo, redNotificationDownloadInfo.purchaserTaxNo) &&
        Objects.equals(this.sellerTaxNo, redNotificationDownloadInfo.sellerTaxNo) &&
        Objects.equals(this.redNotificationNo, redNotificationDownloadInfo.redNotificationNo) &&
        Objects.equals(this.downloadRange, redNotificationDownloadInfo.downloadRange) &&
        Objects.equals(this.pageNo, redNotificationDownloadInfo.pageNo) &&
        Objects.equals(this.pageSize, redNotificationDownloadInfo.pageSize);
  }

  @Override
  public int hashCode() {
    return Objects.hash(requestSerialNo, companyTaxNo, machineCode, overdueStatus, startDate, endDate, purchaserTaxNo, sellerTaxNo, redNotificationNo, downloadRange, pageNo, pageSize);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RedNotificationDownloadInfo {\n");
    
    sb.append("    requestSerialNo: ").append(toIndentedString(requestSerialNo)).append("\n");
    sb.append("    companyTaxNo: ").append(toIndentedString(companyTaxNo)).append("\n");
    sb.append("    machineCode: ").append(toIndentedString(machineCode)).append("\n");
    sb.append("    overdueStatus: ").append(toIndentedString(overdueStatus)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    purchaserTaxNo: ").append(toIndentedString(purchaserTaxNo)).append("\n");
    sb.append("    sellerTaxNo: ").append(toIndentedString(sellerTaxNo)).append("\n");
    sb.append("    redNotificationNo: ").append(toIndentedString(redNotificationNo)).append("\n");
    sb.append("    downloadRange: ").append(toIndentedString(downloadRange)).append("\n");
    sb.append("    pageNo: ").append(toIndentedString(pageNo)).append("\n");
    sb.append("    pageSize: ").append(toIndentedString(pageSize)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
