package com.xforceplus.micro.tax.cherry.contract.model.client;

import lombok.Data;

public class CustomDeclareTaxDetails {
    @Data
    public static class Request {
        /**
         * 开票方式
         */
        private String makeInvoiceMethod;


        /**
         * 预制发票ID
         */
        private String pid;

        /**
         * 发票代码
         */
        private String invoiceCode;

        /**
         * 发票号码
         */
        private String invoiceNo;

        /**
         * 开票日期
         */
        private String invoiceDateTime;

        /**
         * 作废日期
         */
        private String invalidDateTime;

        /**
         * 备注
         */
        private String remark;

        /**
         * 编码表版本号
         */
        private String taxCodeVersion;

        /**
         * 含税金额
         */
        private String amountWithTax;

        /**
         * 不含税金额
         */
        private String amountWithoutTax;

        /**
         * 税额
         */
        private String taxAmount;


        /**
         * 收款人
         */
        private String cashierName;

        /**
         * 复核人
         */
        private String checkerName;

        /**
         * 开票人
         */
        private String drawerName;


        /**
         * 购方名称
         */
        private String purchaserName;

        /**
         * 购方税号
         */
        private String purchaserTaxCode;

        /**
         * 购方地址、电话
         */
        private String purchaserAddressAndTel;

        /**
         * 购方开户行及账号
         */
        private String purchaserBankAndAccount;


        @Data
        public static class productionInfo{
            /**
             * 原发票代码
             */
            private String originalInvoiceCode;
            /**
             * 原发票号码
             */
            private String originalInvoiceNo;
            /**
             * 商品名称
             */
            private String productionName;
            /**
             * 规格型号
             */
            private String specification;
            /**
             * 商品编码
             */
            private String productionCode;
            /**
             * 单位
             */
            private String unitName;
            /**
             * 数量
             */
            private String quantity;
            /**
             * 单价
             */
            private String unitPrice;
            /**
             * 金额
             */
            private String amount;
            /**
             * 税率
             */
            private String taxRate;
            /**
             * 税额
             */
            private String taxAmount;
        }
    }
}
