package com.xforceplus.micro.tax.cherry.contract.model.client;

import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.BaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

public class CustomDeclareTaxMessage {
    @Data
    public static class Request {
        /**
         * 文件格式
         */
        private String fileFormat;

        /**
         * 标题
         */
        private String title;

        /**
         * 制表日期
         */
        private String makeTableDate;

        /**
         * 所属期间
         */
        private String taxPeriod;

        /**
         * 子标题
         */
        private String subTitle;

        /**
         * 子标题2
         */
        private String subTitle2;

        /**
         * 纳税人登记号
         */
        private String taxCode;

        /**
         * 企业名称
         */
        private String companyName;

        /**
         * 地址电话
         */
        private String addressTel;

        /**
         * 分配发票份数
         */
        private String allotInvNum;

        /**
         * 负数发票份数
         */
        private String negativeInvoiceNum;

        /**
         * 负数废票份数
         */
        private String negativeInvWasteNum;

        /**
         * 购进发票份数
         */
        private String buyNum;

        /**
         * 期初库存份数
         */
        private String periodEarlyStockNum;

        /**
         * 期末库存份数
         */
        private String periodEndStockNum;

        /**
         * 收回发票份数
         */
        private String reclaimStockNum;

        /**
         * 退回发票份数
         */
        private String returnInvNum;

        /**
         * 正数发票份数
         */
        private String plusInvoiceNum;

        /**
         * 正数废票份数
         */
        private String plusInvWasteNum;

        /**
         * 销项情况
         */
        private List<GenerateDeclareTaxMessage.OutputInfo> outputDetails;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private CustomDeclareTaxMessage.Result result = new CustomDeclareTaxMessage.Result();
    }

    @Data
    public static class Result {

        /**
         * pdf/xps/excel数据错误信息
         */
        private String taxMonthStatMsg;

        /**
         * 文件格式
         */
        private String fileFormat;

        /**
         * 下载链接
         */
        private String downloadUrl;
    }
}
