package com.xforceplus.micro.tax.cherry.contract.model.common;

import lombok.Data;

/**
 * 电子发票明细
 *
 * @author zhouwen
 * @date 2020-08-11
 */
@Data
public class ElectronicInvoiceDetailInfo {

    /**
     * 明细折扣类型 0-无折扣明细 1-折扣明细 2-被折扣明细
     */
    private String discountType;

    /**
     * 货物或应税劳务名称
     */
    private String cargoName;

    /**
     * 规格型号
     */
    private String itemSpec;

    /**
     * 单位
     */
    private String quantityUnit;

    /**
     * 数量(支持小数点后8位)
     */
    private String quantity;

    /**
     * 单价(支持小数点后8位)
     */
    private String unitPrice;

    /**
     * 不含税金额(支持小数点后2位)
     */
    private String amountWithoutTax;

    /**
     * 税率(示例，16%传0.16)
     */
    private String taxRate;

    /**
     * 税额(支持小数点后2位)
     */
    private String taxAmount;

    /**
     * 税率标志 (空-非0税率；0-出口退税 1-免税 2-不征税 3-普通0税率)
     */
    private String zeroTax;
}
