package com.xforceplus.micro.tax.cherry.contract.model.controller;

import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.BaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author Bobo
 * @create 2020/12/18 10:57
 * @since 1.0.0
 */
public class CertificateListMessage {

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private CertificateListMessage.Response.Result result = new CertificateListMessage.Response.Result();

        @Data
        public class Result {

            /**
             * 分页信息
             */
            private Page page;

            private List<Certificate> data;

        }
    }

    @Data
    public static class Page {

        /**
         * 当前页码
         */
        private Integer currentPage;

        /**
         * 每页条数
         */
        private Integer pageSize;

        /**
         * 总数据条数
         */
        private Integer totalNum;

    }

    @Data
    public static class Certificate {

        /**
         * 税号
         */
        private String taxCode;

        /**
         * 公司名称
         */
        private String name;

        /**
         * 分组代码
         */
        private String groupCode;

        /**
         * 企业所在省
         */
        private String province;

        /**
         * 企业所在市
         */
        private String city;

        /**
         * 公司签章地址
         */
        private String signatureUrl;

        /**
         * 创建时间（格式：yyyyMMddHHmissSSS）
         */
        private String createTime;

        /**
         * 创建人
         */
        private String operatedBy;

        /**
         * 证书有效期（格式：yyyyMMddHHmissSSS）
         */
        private String certValidity;

    }
}
