package com.xforceplus.micro.tax.cherry.contract.model.enumerate;

import org.apache.commons.lang3.StringUtils;

import javax.validation.constraints.NotNull;

/**
 * 发票通道类型枚举
 */
public enum InvoiceChannelEnum {
    /**
     * 发票服务平台开票
     */
    VAT_MAKE_INVOICE(0, "vukey"),

    /**
     * 百旺税控服务器
     */
    BW(5, "bw"),

    /**
     * 百旺云V1
     */
    BW_CLOUD_V1(1, "bw-v1"),

    /**
     * 百旺云V1
     */
    BW_CLOUD_V2(9, "bw-v2"),

    /**
     * 航信非自建税控服务器
     */
    HX(3, "hx"),

    /**
     * 航信标准版
     */
    HX_NORMAL(6, "hx-normal"),

    /**
     * 航信易票云
     */
    HX_YP_CLOUD(7, "hx-yp"),

    /**
     * 航信诺诺
     */
    HX_NUONUO(8, "hx-nuonuo"),

    /**
     * 河马开票--数族
     */
    HIPPO_MAKE_INVOICE(10, "hippo");

    private int code;
    private String name;

    InvoiceChannelEnum(int code, String name) {

        this.code = code;
        this.name = name;
    }

    @NotNull
    public int toCode() {
        return code;
    }

    public String toName() {
        return name;
    }

    public static InvoiceChannelEnum fromCode(Integer code) {

        if (code == null) {
            return null;
        }

        final InvoiceChannelEnum[] values = InvoiceChannelEnum.values();

        for (InvoiceChannelEnum modeEnum : values) {
            if (modeEnum.code == code) {
                return modeEnum;
            }
        }

        return null;
    }

    public static InvoiceChannelEnum fromName(String name) {

        if (StringUtils.isBlank(name)) {
            return null;
        }

        final InvoiceChannelEnum[] values = InvoiceChannelEnum.values();

        for (InvoiceChannelEnum modeEnum : values) {
            if (StringUtils.equals(modeEnum.name, name)) {
                return modeEnum;
            }
        }

        return null;
    }
}
