package com.xforceplus.micro.tax.cherry.contract.model.pdf;

import com.xforceplus.micro.tax.cherry.contract.model.common.*;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * 生成PDF
 *
 * @author zhouwen
 * @date 2020-08-11
 * @comment 此定义与Swagger生成的GeneratePDFRequest和GeneratePDFResponse字段一致，
 * 目的是避免Swagger用fastJson序列化问题，如需调整字段需要两边保持一致；
 */
public class GeneratePDFMessage {

    @Data
    public static class Request {

        /**
         * 标准请求头信息
         */
        private RequestHead head;

        /**
         * 电子发票信息
         */
        private ElectronicInvoiceInfo electronicInvoiceInfo = new ElectronicInvoiceInfo();
    }

    @Data
    public static class Response {

        /**
         * 标准响应头
         */
        private ResponseHead head;

        /**
         * pdf访问地址
         */
        private String pdfUrl;

        /**
         * pdf短链访问地址
         */
        private String shortUrl;

        /**
         * 未签名PDF文件(Base64)
         */
        private String pdfEncode;

        /**
         * 签章文件(Base64)
         */
        private String signatureEncode;

        /**
         * 多云地址列表
         */
        private List<MultiCloudAddr> multiCloudAddrList = new ArrayList<>();
    }

    @Data
    public static class RequestHead {
        /**
         * 调试信息(仅供调试使用)
         */
        private String debug;
    }

    @Data
    public static class ResponseHead {

        /**
         * (必填)返回代码  正数成功, 负数失败
         */
        private Integer code = 1;

        /**
         * 返回子代码 不一定有值，一般用来编码更具体的处理结果。调用方可以用来映射自定义的Message
         */
        private String subCode;

        /**
         * 返回信息
         */
        private String message;

        /**
         * （必填）时间戳
         */
        private String timestamp;

        /**
         * （必填）耗时
         */
        private Long timeCost;

        /**
         * （必填）内部调用id，调用接口出现问题，提供此字段给税件调查
         */
        private String traceId;
    }

    @Data
    public static class ElectronicInvoiceInfo {

        /**
         * 发票类型（ec:电票,默认:ec）
         */
        private String invoiceType = "ec";

        /**
         * 机器码
         */
        private String machineCode;

        /**
         * 发票号码
         */
        private String invoiceNo;

        /**
         * 发票代码
         */
        private String invoiceCode;

        /**
         * 开票日期(yyyyMMdd)
         */
        private String invoiceDate;

        /**
         * 校验码
         */
        private String checkCode;

        /**
         * 发票密文
         */
        private String cipherText;

        /**
         * 备注
         */
        private String remark;

        /**
         * 购方信息
         */
        private PurchaserInfo purchaser = new PurchaserInfo();

        /**
         * 销方信息
         */
        private SellerInfo seller = new SellerInfo();

        /**
         * 合计金额信息
         */
        private InvoiceAmountInfo amountInfo = new InvoiceAmountInfo();

        /**
         * 经办人
         */
        private OperatorInfo operator = new OperatorInfo();

        /**
         * 电子发票明细
         */
        private List<ElectronicInvoiceDetailInfo> details = new ArrayList<>();

        /**
         * 发票控制项
         */
        private InvoiceControlInfo control = new InvoiceControlInfo();
    }
}
