package com.xforceplus.micro.tax.cherry.contract.model.pdf;

import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.BaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * PDF签名转换
 *
 * @author Bobo
 * @create 2021/5/28 15:42
 * @since 1.0.0
 */
public class TranslationPDFSignatureMessage {

    @Data
    public static class Request {

        /**
         * 流水号
         */
        private String serialNo;

        /**
         * 发票代码
         */
        private String invoiceCode;

        /**
         * 发票号码
         */
        private String invoiceNo;

        /**
         * 已签名PDF文件（Base64）
         */
        private String pdfEncode;

    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private Result result = new Result();

        @Data
        public class Result {

            /**
             * 发票凭证Url
             */
            private String voucherUrl;

        }
    }
}
