package com.xforceplus.micro.tax.cherry.contract.model.vatv2;

import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.BaseResponseDto;
import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.device.DeviceDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author Bobo
 * @create 2020/4/1 17:03
 * @since 1.0.0
 */
public class AddTerminalMessage {

    @Data
    public static class Request {

        /**
         * 发票类型
         */
        private String invoiceType;

        /**
         * 虚拟设备信息
         */
        private DeviceDto deviceInfo;

    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private Result result = new Result();
    }

    @Data
    public static class Result {

        /**
         * 开票终端代码
         */
        private String terminalNo;
    }
}
