package com.xforceplus.micro.tax.cherry.contract.model.vatv2;

import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.BaseResponseDto;
import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.device.DeviceIssueDto;
import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.device.ServerDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 虚拟UKey发行
 *
 * @author Bobo
 * @create 2020/4/1 19:33
 * @since 1.0.0
 */
public class DeviceIssueMessage {

    @Data
    public static class Request {

        /**
         * 发票类型
         */
        private String invoiceType;

        /**
         * 税号
         */
        private String taxCode;

        /**
         * 服务器信息
         */
        private ServerDto serverInfo;

    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private DeviceIssueMessage.Result result = new DeviceIssueMessage.Result();

    }

    @Data
    public static class Result {

        private DeviceIssueDto deviceIssueInfo;
    }


}
