package com.xforceplus.micro.tax.cherry.contract.model.vatv2;

import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.BaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * ofd解析发票信息
 *
 * @author zhouwen
 * @date 2020-04-23
 */
public class OfdParseInvoiceMessage {

    @Data
    public static class Request {

        /**
         * ofd文件Base64
         */
        private String ofdEncode;

        /**
         * 是否受信任
         */
        private boolean trustFlag;

        /**
         * ofd上传时获取的唯一码
         */
        private String ofdKey;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private Result result = new Result();

        @Data
        public static class Result {

            /**
             * ofd发票XML-Base64(original-invoice.xml)
             */
            private String invoiceEncode;
        }

    }
}
