package com.xforceplus.micro.tax.cherry.contract.model.vatv2;

import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.BaseResponseDto;
import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.device.DeviceDto;
import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.invoice.red.RedDownloadDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 红字下载
 *
 * @author zhouwen
 * @date 2020-05-19
 */
public class RedDownloadMessage {

    @Data
    public static class Request {

        /**
         * 设备服务器信息
         */
        private DeviceDto deviceInfo;

        /**
         * 发票类型
         */
        private String originalInvoiceType;

        /**
         * 逾期状态：N-非逾期; Y-逾期
         */
        private String overdueStatus;

        /**
         * 填开日期起
         */
        private String startApplyDate;

        /**
         * 填开日期止
         */
        private String endApplyDate;

        /**
         * 购方税号
         */
        private String purchaserTaxCode;

        /**
         * 销方税号
         */
        private String sellerTaxCode;

        /**
         * 红字信息表编号
         */
        private String redNotificationNo;

        /**
         * 下载范围：0 全部；1 本企业申请；2 其它企业申请
         */
        private String downloadScope;

        /**
         * 页号
         */
        private String pageNo;

        /**
         * 页数
         */
        private String pageCount;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private Result result = new Result();

        @Data
        public static class Result {

            /**
             * 记录总数
             */
            private String recordCount;

            /**
             * 红字下载列表
             */
            private List<RedDownloadDto> redDownloadList;
        }
    }
}
