package com.xforceplus.micro.tax.cherry.contract.model.vatv2;

import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.BaseResponseDto;
import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.device.DeviceDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 汇总数据抄报
 *
 * @author Bobo
 * @create 2020/4/3 21:45
 * @since 1.0.0
 */
public class SumDataRepMessage {

    @Data
    public static class Request {

        /**
         * 设备服务器信息
         */
        private DeviceDto deviceDto;

        /**
         * 发票类型(ce-电票,s-专票, c-普票)
         */
        private String invoiceType;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

    }

}
