package com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.invoice;

import lombok.Data;

/**
 * 发票基础信息
 *
 * @author Bobo
 * @create 2020/3/9 16:13
 * @since 1.0.0
 */
@Data
public class BaseInvoiceDto {

    /**
     * 预制发票ID(必须全局唯一)
     */
    private String pid;

    /**
     * 发票类型(ce-电票,s-专票, c-普票)
     */
    private String invoiceType;

    /**
     * 特殊票种标识
     * 00-非特殊票种,02-农产品收购,06-抵扣通行费,07-其它通行费,08-成品油销售,18-成品油专票负数发票
     */
    private String itemTypeCode;

    /**
     * 编码表版本号
     */
    private String taxCodeVersion;

    /**
     * 含税税率标识(类似征收方式）
     * 0：普通征税,1：减按计征,2：差额征税
     */
    private String dupTaxFlag;

    /**
     * 扣除额（保留小数点后2位）
     */
    private String taxDeductionAmount;

    /**
     * 备注
     */
    private String remark;

    /**
     * 清单标志
     */
    private Boolean saleListFlag;

    /**
     * 发票合计金额
     */
    private InvoiceAmountDto invoiceAmount;

    /**
     * 经办人
     */
    private OperatorDto operator;

    /**
     * 购方
     */
    private PurchaserDto purchaser;

    /**
     * 销方
     */
    private SellerDto seller;

    /**
     * 红字信息
     */
    private RedInfoDto redInfo;

    /**
     * ofd业务埋点
     */
    private OfdBizDataDto ofdBizData;

}
