package com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.invoice;

import lombok.Data;
import org.apache.commons.lang3.StringUtils;

/**
 * 购方
 *
 * @author Bobo
 * @create 2020/3/7 16:13
 * @since 1.0.0
 */
@Data
public class PurchaserDto {

    /**
     * 购方税号
     */
    private String purchaserTaxCode;

    /**
     * 购方名称-必须
     */
    private String purchaserName;

    /**
     * 购方地址
     */
    private String purchaserAddress;

    /**
     * 购方电话
     */
    private String purchaserTel;

    /**
     * 购方开户行名称
     */
    private String purchaserBankName;

    /**
     * 购方银行账号
     */
    private String purchaserBankAccount;

    public String getPurchaserAddressAndTel() {
        return concat(purchaserAddress, purchaserTel);
    }

    public String getPurchaserBankAndAccount() {
        return concat(purchaserBankName, purchaserBankAccount);
    }

    private static String concat(String source1, String source2) {
        return String.format("%s %s", StringUtils.defaultString(source1).trim(),
                StringUtils.defaultString(source2).trim()).trim();
    }

}
