package com.xforceplus.micro.tax.cherry.contract.model.vatv2.redapply;

import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.BaseResponseDto;
import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.terminal.TerminalDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 红字申请
 *
 * @author Bobo
 * @create 2021/5/14 15:22
 * @since 1.0.0
 */
public class RedNotificationsApplyMessage {

    @Data
    public static class Request {

        /**
         * 流水号
         */
        private String serialNo;

        /**
         * 租户
         */
        private String tenantId;

        /**
         * 通道类型 （bw：百旺税控服务器 bw-v1:百旺云V1）
         */
        private String channel;

        /**
         * 开票终端信息
         */
        private TerminalDto terminalInfo;

        /**
         * 红字申请信息
         */
        private RedNotificationsApplyDto redApplyV2Dto;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        /**
         * 结果
         */
        private Result result = new Result();

        @Data
        public static class Result {

            /**
             * 流水号
             */
            private String serialNo;

            /**
             * 租户
             */
            private String tenantId;

            /**
             * 红字信息表
             */
            private RedNotificationDto redNotificationDto;

        }
    }
}
