package com.xforceplus.micro.tax.cherry.contract.model.vatv2.redapply;

import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.BaseResponseDto;
import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.terminal.TerminalDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 红字信息表下载
 *
 * @author Bobo
 * @create 2021/5/14 17:04
 * @since 1.0.0
 */
public class RedNotificationsDownloadMessage {

    @Data
    public static class Request {

        /**
         * 流水号
         */
        private String serialNo;

        /**
         * 租户
         */
        private String tenantId;

        /**
         * 通道类型 （bw：百旺税控服务器 bw-v1:百旺云V1）
         */
        private String channel;

        /**
         * 开票终端信息
         */
        private TerminalDto terminalInfo;

        /**
         * 对应蓝票发票类型（s:纸专,se:电专;默认:s）
         */
        private String originalInvoiceType;

        /**
         * 红字信息表编号（填开日期都为空时，必填）
         */
        private String redNotificationNo;

        /**
         * 填开起始日期（红字信息表编号为空时，必填；格式：yyyyMMdd）
         */
        private String startDate;

        /**
         * 填开截止日期（红字信息表编号为空时，必填；格式：yyyyMMdd）
         */
        private String endDate;

        /**
         * 红字信息表摘要
         */
        private List<RedNotificationSummaryDTO> summaryList;
        ;

        @Data
        public static class RedNotificationSummaryDTO {

            /**
             * 红字信息表编号
             */
            private String redNotificationNo;

            /**
             * 红字信息表状态
             */
            private String status;

        }
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        /**
         * 结果
         */
        private Result result = new Result();

        @Data
        public static class Result {

            /**
             * 流水号
             */
            private String serialNo;

            /**
             * 红字信息表
             */
            private List<RedNotificationDto> redNotificationDtoList;

        }
    }
}
