/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.micro.tax.cherry.contract.model.enumerate;

import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;

public enum InvoiceChannelEnum {
    V_UKEY(0, "vukey"),
    BW_S(5, "bw-s"),
    BW_CLOUD_V1(1, "bw-v1"),
    BW_CLOUD_V2(9, "bw-v2"),
    HX_C(3, "hx-c"),
    HX_NORMAL(6, "hx-normal"),
    HX_YP_CLOUD(7, "hx-yp"),
    HX_NUONUO(8, "hx-nuonuo"),
    HIPPO_MAKE_INVOICE(10, "hippo"),
    PROVIDER_MAKE_INVOICE_BW(21, "provider-bw"),
    PROVIDER_MAKE_INVOICE_HX(22, "provider-hx"),
    PROVIDER_MAKE_INVOICE_EK(23, "provider-ek");

    private int code;
    private String name;

    private InvoiceChannelEnum(int code, String name) {
        this.code = code;
        this.name = name;
    }

    @NotNull
    public int toCode() {
        return this.code;
    }

    public String toName() {
        return this.name;
    }

    public static InvoiceChannelEnum fromCode(Integer code) {
        InvoiceChannelEnum[] values;
        if (code == null) {
            return null;
        }
        for (InvoiceChannelEnum modeEnum : values = InvoiceChannelEnum.values()) {
            if (modeEnum.code != code) continue;
            return modeEnum;
        }
        return null;
    }

    public static InvoiceChannelEnum fromName(String name) {
        InvoiceChannelEnum[] values;
        if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        if (StringUtils.equals((CharSequence)name, (CharSequence)"bw")) {
            return BW_S;
        }
        if (StringUtils.equals((CharSequence)name, (CharSequence)"hx")) {
            return HX_C;
        }
        for (InvoiceChannelEnum modeEnum : values = InvoiceChannelEnum.values()) {
            if (!StringUtils.equals((CharSequence)modeEnum.name.toLowerCase(), (CharSequence)name.toLowerCase())) continue;
            return modeEnum;
        }
        return null;
    }
}

