package com.xforceplus.micro.tax.cherry.contract.server;

import com.xforceplus.micro.tax.cherry.contract.model.GeneratePDFRequest;
import com.xforceplus.micro.tax.cherry.contract.model.GeneratePDFResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "electronicInvoice", description = "the electronicInvoice API")
public interface ElectronicInvoiceApi {

    @ApiOperation(value = "生成电票PDF", notes = "", response = GeneratePDFResponse.class, tags={ "ElectronicInvoice", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "生成PDF响应", response = GeneratePDFResponse.class) })
    @RequestMapping(value = "/electronicInvoice/generatePDF",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default GeneratePDFResponse electronicInvoiceGeneratePDFPost(@ApiParam(value = "生成PDF"  )  @Valid @RequestBody GeneratePDFRequest generatePDFRequest) {
        Object[] params = new Object[] { generatePDFRequest };
        //return FixtureService.getInstance().get(GeneratePDFResponse.class, ElectronicInvoiceApi.class, "electronicInvoiceGeneratePDFPost", params);
        return null;
    }
}
