package com.xforceplus.micro.tax.cherry.contract.server;

import com.xforceplus.micro.tax.cherry.contract.model.GeneratePrintPDFRequest;
import com.xforceplus.micro.tax.cherry.contract.model.GeneratePrintPDFResponse;
import com.xforceplus.micro.tax.cherry.contract.model.SalesListPrintPDFRequest;
import com.xforceplus.micro.tax.cherry.contract.model.SalesListPrintPDFResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "invoicePrint", description = "the invoicePrint API")
public interface InvoicePrintApi {

    @ApiOperation(value = "生成待打印销货清单PDF接口", notes = "", response = SalesListPrintPDFResponse.class, tags={ "InvoicePrint", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "生成待打印销货清单PDF响应", response = SalesListPrintPDFResponse.class) })
    @RequestMapping(value = "/invoicePrint/salesList/generatePDF",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default SalesListPrintPDFResponse generateSalesListPrintPDF(@ApiParam(value = "生成待打印销货清单PDF"  )  @Valid @RequestBody SalesListPrintPDFRequest salesListPrintPDFRequest) {
        Object[] params = new Object[] { salesListPrintPDFRequest };
        //return FixtureService.getInstance().get(SalesListPrintPDFResponse.class, InvoicePrintApi.class, "generateSalesListPrintPDF", params);
        return null;
    }

    @ApiOperation(value = "生成待打印发票PDF", notes = "", response = GeneratePrintPDFResponse.class, tags={ "InvoicePrint", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "生成待打印发票PDF响应", response = GeneratePrintPDFResponse.class) })
    @RequestMapping(value = "/invoicePrint/generatePDF",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default GeneratePrintPDFResponse invoicePrintGeneratePDFPost(@ApiParam(value = "生成待打印发票PDF"  )  @Valid @RequestBody GeneratePrintPDFRequest generatePrintPDFRequest) {
        Object[] params = new Object[] { generatePrintPDFRequest };
        //return FixtureService.getInstance().get(GeneratePrintPDFResponse.class, InvoicePrintApi.class, "invoicePrintGeneratePDFPost", params);
        return null;
    }
}
