package com.xforceplus.micro.tax.cherry.contract.server;

import com.xforceplus.micro.tax.cherry.contract.model.ReceiveBackRequest;
import com.xforceplus.micro.tax.cherry.contract.model.ReceiveBackResponse;
import com.xforceplus.micro.tax.cherry.contract.model.ReceiveDispatcherRequest;
import com.xforceplus.micro.tax.cherry.contract.model.ReceiveDispatcherResponse;
import com.xforceplus.micro.tax.cherry.contract.model.ReceiveRequest;
import com.xforceplus.micro.tax.cherry.contract.model.ReceiveResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "invoiceStock", description = "the invoiceStock API")
public interface InvoiceStockApi {

    @ApiOperation(value = "发票领购信息退回接口", notes = "", response = ReceiveBackResponse.class, tags={ "InvoiceStock", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "发票领购信息退回响应", response = ReceiveBackResponse.class) })
    @RequestMapping(value = "/invoiceStock/receiveInfo/back",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default ReceiveBackResponse invoiceStockReceiveInfoBackPost(@ApiParam(value = "发票领购信息退回请求"  )  @Valid @RequestBody ReceiveBackRequest receiveBackRequest) {
        Object[] params = new Object[] { receiveBackRequest };
        //return FixtureService.getInstance().get(ReceiveBackResponse.class, InvoiceStockApi.class, "invoiceStockReceiveInfoBackPost", params);
        return null;
    }

    @ApiOperation(value = "发票领购信息分发接口", notes = "", response = ReceiveDispatcherResponse.class, tags={ "InvoiceStock", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "发票领购信息分发响应", response = ReceiveDispatcherResponse.class) })
    @RequestMapping(value = "/invoiceStock/receiveInfo/dispatcher",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default ReceiveDispatcherResponse invoiceStockReceiveInfoDispatcherPost(@ApiParam(value = "发票领购信息分发请求"  )  @Valid @RequestBody ReceiveDispatcherRequest receiveDispatcherRequest) {
        Object[] params = new Object[] { receiveDispatcherRequest };
        //return FixtureService.getInstance().get(ReceiveDispatcherResponse.class, InvoiceStockApi.class, "invoiceStockReceiveInfoDispatcherPost", params);
        return null;
    }

    @ApiOperation(value = "获取未分发发票信息接口", notes = "", response = ReceiveResponse.class, tags={ "InvoiceStock", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "发票领购信息响应", response = ReceiveResponse.class) })
    @RequestMapping(value = "/invoiceStock/receiveInfo",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default ReceiveResponse invoiceStockReceiveInfoPost(@ApiParam(value = "获取未分发发票信息请求"  )  @Valid @RequestBody ReceiveRequest receiveRequest) {
        Object[] params = new Object[] { receiveRequest };
        //return FixtureService.getInstance().get(ReceiveResponse.class, InvoiceStockApi.class, "invoiceStockReceiveInfoPost", params);
        return null;
    }
}
