package com.xforceplus.micro.tax.cherry.contract.server;

import com.xforceplus.micro.tax.cherry.contract.model.GenerateRedNotificationPDFRequest;
import com.xforceplus.micro.tax.cherry.contract.model.GenerateRedNotificationPDFResponse;
import com.xforceplus.micro.tax.cherry.contract.model.RedApplyRequest;
import com.xforceplus.micro.tax.cherry.contract.model.RedApplyResponse;
import com.xforceplus.micro.tax.cherry.contract.model.RedSyncRequest;
import com.xforceplus.micro.tax.cherry.contract.model.RedSyncResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "redNotification", description = "the redNotification API")
public interface RedNotificationApi {

    @ApiOperation(value = "红字信息表申请", notes = "", response = RedApplyResponse.class, tags={ "RedNotification", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "红字信息表申请响应", response = RedApplyResponse.class) })
    @RequestMapping(value = "/redNotification/apply",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default RedApplyResponse redApply(@ApiParam(value = "红字信息表申请"  )  @Valid @RequestBody RedApplyRequest redApplyRequest) {
        Object[] params = new Object[] { redApplyRequest };
        //return FixtureService.getInstance().get(RedApplyResponse.class, RedNotificationApi.class, "redApply", params);
        return null;
    }

    @ApiOperation(value = "生成红字发票信息表PDF", notes = "", response = GenerateRedNotificationPDFResponse.class, tags={ "RedNotification", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "生成红字发票信息表PDF响应", response = GenerateRedNotificationPDFResponse.class) })
    @RequestMapping(value = "/redNotification/generatePDF",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default GenerateRedNotificationPDFResponse redNotificationGeneratePDFPost(@ApiParam(value = "生成红字发票信息表PDF请求"  )  @Valid @RequestBody GenerateRedNotificationPDFRequest generateRedNotificationPDFRequest) {
        Object[] params = new Object[] { generateRedNotificationPDFRequest };
        //return FixtureService.getInstance().get(GenerateRedNotificationPDFResponse.class, RedNotificationApi.class, "redNotificationGeneratePDFPost", params);
        return null;
    }

    @ApiOperation(value = "红字信息表同步", notes = "", response = RedSyncResponse.class, tags={ "RedNotification", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "红字信息表同步响应", response = RedSyncResponse.class) })
    @RequestMapping(value = "/redNotification/sync",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default RedSyncResponse redSync(@ApiParam(value = "红字信息表下载请求"  )  @Valid @RequestBody RedSyncRequest redSyncRequest) {
        Object[] params = new Object[] { redSyncRequest };
        //return FixtureService.getInstance().get(RedSyncResponse.class, RedNotificationApi.class, "redSync", params);
        return null;
    }
}
