package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.DeviceInfo;
import com.xforceplus.micro.tax.device.contract.model.LicenseInfo;
import com.xforceplus.micro.tax.device.contract.model.RequestHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * AddDeviceRequest
 */

@JsonInclude(NON_NULL)
public class AddDeviceRequest implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private RequestHead head = null;

  @JsonProperty("deviceInfo")
  private DeviceInfo deviceInfo = null;

  @JsonProperty("licenseInfo")
  private LicenseInfo licenseInfo = null;

  @JsonIgnore
  public AddDeviceRequest head(RequestHead head) {
    this.head = head;
    return this;
  }

   /**
   * 标准请求头信息
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "标准请求头信息")
  public RequestHead getHead() {
    return head;
  }

  public void setHead(RequestHead head) {
    this.head = head;
  }

  @JsonIgnore
  public AddDeviceRequest deviceInfo(DeviceInfo deviceInfo) {
    this.deviceInfo = deviceInfo;
    return this;
  }

   /**
   * 设备信息
   * @return deviceInfo
  **/

  @Valid

  @ApiModelProperty(value = "设备信息")
  public DeviceInfo getDeviceInfo() {
    return deviceInfo;
  }

  public void setDeviceInfo(DeviceInfo deviceInfo) {
    this.deviceInfo = deviceInfo;
  }

  @JsonIgnore
  public AddDeviceRequest licenseInfo(LicenseInfo licenseInfo) {
    this.licenseInfo = licenseInfo;
    return this;
  }

   /**
   * 授权信息,税控钥匙启用时传入，税盘审核通过状态时传入
   * @return licenseInfo
  **/

  @Valid

  @ApiModelProperty(value = "授权信息,税控钥匙启用时传入，税盘审核通过状态时传入")
  public LicenseInfo getLicenseInfo() {
    return licenseInfo;
  }

  public void setLicenseInfo(LicenseInfo licenseInfo) {
    this.licenseInfo = licenseInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AddDeviceRequest addDeviceRequest = (AddDeviceRequest) o;
    return Objects.equals(this.head, addDeviceRequest.head) &&
        Objects.equals(this.deviceInfo, addDeviceRequest.deviceInfo) &&
        Objects.equals(this.licenseInfo, addDeviceRequest.licenseInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, deviceInfo, licenseInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AddDeviceRequest {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    deviceInfo: ").append(toIndentedString(deviceInfo)).append("\n");
    sb.append("    licenseInfo: ").append(toIndentedString(licenseInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
