package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.LicenseInfo;
import com.xforceplus.micro.tax.device.contract.model.RequestHead;
import com.xforceplus.micro.tax.device.contract.model.TerminalInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * AddTerminalRequest
 */

@JsonInclude(NON_NULL)
public class AddTerminalRequest implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private RequestHead head = null;

  @JsonProperty("terminalInfo")
  private TerminalInfo terminalInfo = null;

  @JsonProperty("licenseInfo")
  private LicenseInfo licenseInfo = null;

  @JsonIgnore
  public AddTerminalRequest head(RequestHead head) {
    this.head = head;
    return this;
  }

   /**
   * 标准请求头信息
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "标准请求头信息")
  public RequestHead getHead() {
    return head;
  }

  public void setHead(RequestHead head) {
    this.head = head;
  }

  @JsonIgnore
  public AddTerminalRequest terminalInfo(TerminalInfo terminalInfo) {
    this.terminalInfo = terminalInfo;
    return this;
  }

   /**
   * 终端信息
   * @return terminalInfo
  **/

  @Valid

  @ApiModelProperty(value = "终端信息")
  public TerminalInfo getTerminalInfo() {
    return terminalInfo;
  }

  public void setTerminalInfo(TerminalInfo terminalInfo) {
    this.terminalInfo = terminalInfo;
  }

  @JsonIgnore
  public AddTerminalRequest licenseInfo(LicenseInfo licenseInfo) {
    this.licenseInfo = licenseInfo;
    return this;
  }

   /**
   * 授权信息,状态为启用状态时传入
   * @return licenseInfo
  **/

  @Valid

  @ApiModelProperty(value = "授权信息,状态为启用状态时传入")
  public LicenseInfo getLicenseInfo() {
    return licenseInfo;
  }

  public void setLicenseInfo(LicenseInfo licenseInfo) {
    this.licenseInfo = licenseInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AddTerminalRequest addTerminalRequest = (AddTerminalRequest) o;
    return Objects.equals(this.head, addTerminalRequest.head) &&
        Objects.equals(this.terminalInfo, addTerminalRequest.terminalInfo) &&
        Objects.equals(this.licenseInfo, addTerminalRequest.licenseInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, terminalInfo, licenseInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AddTerminalRequest {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    terminalInfo: ").append(toIndentedString(terminalInfo)).append("\n");
    sb.append("    licenseInfo: ").append(toIndentedString(licenseInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
